/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomePrint;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.LocalizedUndoableEdit;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public class PageSetupController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final UndoableEditSupport undoSupport;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView pageSetupView;
    private HomePrint print;

    public PageSetupController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.setPrint(home.getPrint());
    }

    @Override
    public DialogView getView() {
        if (this.pageSetupView == null) {
            this.pageSetupView = this.viewFactory.createPageSetupView(this.preferences, this);
        }
        return this.pageSetupView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void setPrint(HomePrint homePrint) {
        if (homePrint != this.print) {
            HomePrint homePrint2 = this.print;
            this.print = homePrint;
            this.propertyChangeSupport.firePropertyChange(Property.PRINT.name(), homePrint2, homePrint);
        }
    }

    public HomePrint getPrint() {
        return this.print;
    }

    public List<Level> getPrintableLevels() {
        return this.home.getLevels();
    }

    public void modifyPageSetup() {
        HomePrint homePrint = this.home.getPrint();
        HomePrint homePrint2 = this.getPrint();
        this.home.setPrint(homePrint2);
        HomePrintModificationUndoableEdit homePrintModificationUndoableEdit = new HomePrintModificationUndoableEdit(this.home, this.preferences, homePrint, homePrint2);
        this.undoSupport.postEdit(homePrintModificationUndoableEdit);
    }

    public static enum Property {
        PRINT;

    }

    private static class HomePrintModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final Home home;
        private final HomePrint oldHomePrint;
        private final HomePrint homePrint;

        private HomePrintModificationUndoableEdit(Home home, UserPreferences userPreferences, HomePrint homePrint, HomePrint homePrint2) {
            super(userPreferences, PageSetupController.class, "undoPageSetupName");
            this.home = home;
            this.oldHomePrint = homePrint;
            this.homePrint = homePrint2;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.home.setPrint(this.oldHomePrint);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.home.setPrint(this.homePrint);
        }
    }
}

