/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.Table;

class ColrTable
implements Table {
    private final int _version;
    private final int _numBaseGlyphRecords;
    private final int _offsetBaseGlyphRecord;
    private final int _offsetLayerRecord;
    private final int _numLayerRecords;
    private final BaseGlyphRecord[] _baseGlyphRecords;
    private final LayerRecord[] _layerRecords;

    protected ColrTable(DataInput dataInput) throws IOException {
        int n;
        this._version = dataInput.readUnsignedShort();
        this._numBaseGlyphRecords = dataInput.readUnsignedShort();
        this._offsetBaseGlyphRecord = dataInput.readInt();
        this._offsetLayerRecord = dataInput.readInt();
        this._numLayerRecords = dataInput.readUnsignedShort();
        int n2 = 14;
        if (this._offsetBaseGlyphRecord > n2) {
            dataInput.skipBytes(n2 - this._offsetBaseGlyphRecord);
        }
        this._baseGlyphRecords = new BaseGlyphRecord[this._numBaseGlyphRecords];
        for (n = 0; n < this._numBaseGlyphRecords; ++n) {
            this._baseGlyphRecords[n] = new BaseGlyphRecord(dataInput);
            n2 += 6;
        }
        if (this._offsetLayerRecord > n2) {
            dataInput.skipBytes(n2 - this._offsetLayerRecord);
        }
        this._layerRecords = new LayerRecord[this._numLayerRecords];
        for (n = 0; n < this._numLayerRecords; ++n) {
            this._layerRecords[n] = new LayerRecord(dataInput);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'COLR' Table\n------------\nBase Glyph Records\n");
        for (BaseGlyphRecord object : this._baseGlyphRecords) {
            stringBuilder.append(String.format("%d : %d, %d\n", object.getGid(), object.getFirstLayerIndex(), object.getNumLayers()));
        }
        stringBuilder.append("\nLayer Records\n");
        for (LayerRecord layerRecord : this._layerRecords) {
            stringBuilder.append(String.format("%d : %d\n", layerRecord.getGid(), layerRecord.getPaletteIndex()));
        }
        return stringBuilder.toString();
    }

    static class BaseGlyphRecord {
        private final int _gid;
        private final int _firstLayerIndex;
        private final int _numLayers;

        BaseGlyphRecord(DataInput dataInput) throws IOException {
            this._gid = dataInput.readUnsignedShort();
            this._firstLayerIndex = dataInput.readUnsignedShort();
            this._numLayers = dataInput.readUnsignedShort();
        }

        int getGid() {
            return this._gid;
        }

        int getFirstLayerIndex() {
            return this._firstLayerIndex;
        }

        int getNumLayers() {
            return this._numLayers;
        }
    }

    static class LayerRecord {
        private final int _gid;
        private final int _paletteIndex;

        LayerRecord(DataInput dataInput) throws IOException {
            this._gid = dataInput.readUnsignedShort();
            this._paletteIndex = dataInput.readUnsignedShort();
        }

        int getGid() {
            return this._gid;
        }

        int getPaletteIndex() {
            return this._paletteIndex;
        }
    }
}

