/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run.filter;

import com.intellij.execution.filters.Filter;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.management.PythonPackageManagerExt;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.run.filter.InstallPackageButtonItem;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/run/filter/PythonInstallPackageFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "setEditor", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "isDumbAware", "", "Companion", "intellij.python.community.impl"})
public final class PythonInstallPackageFilter
implements Filter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private EditorImpl editor;

    public PythonInstallPackageFilter(@NotNull Project project, @Nullable EditorImpl editor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.editor = editor2;
    }

    public /* synthetic */ PythonInstallPackageFilter(Project project, EditorImpl editorImpl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            editorImpl = null;
        }
        this(project, editorImpl);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final EditorImpl getEditor() {
        return this.editor;
    }

    public final void setEditor(@Nullable EditorImpl editorImpl) {
        this.editor = editorImpl;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Pair<Sdk, String> pair = Companion.getInstallablePackageName(this.project, this.editor, line);
        if (pair == null) {
            return null;
        }
        Pair<Sdk, String> pair2 = pair;
        Sdk pythonSdk = (Sdk)pair2.component1();
        String packageName = (String)pair2.component2();
        InstallPackageButtonItem info = new InstallPackageButtonItem(this.project, pythonSdk, entireLength - line.length() + 20, packageName);
        Object[] objectArray = new Filter.ResultItem[]{info, new Filter.ResultItem(0, 0, null)};
        return new Filter.Result(CollectionsKt.listOf((Object[])objectArray));
    }

    @ApiStatus.Internal
    public boolean isDumbAware() {
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u001c\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tJ.\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/run/filter/PythonInstallPackageFilter$Companion;", "", "<init>", "()V", "getSdkForFile", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getSdk", "getInstallablePackageName", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "line", "intellij.python.community.impl"})
    @ApiStatus.Internal
    @SourceDebugExtension(value={"SMAP\nPythonInstallPackageFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonInstallPackageFilter.kt\ncom/jetbrains/python/run/filter/PythonInstallPackageFilter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,75:1\n295#2,2:76\n1#3:78\n389#4,4:79\n*S KotlinDebug\n*F\n+ 1 PythonInstallPackageFilter.kt\ncom/jetbrains/python/run/filter/PythonInstallPackageFilter$Companion\n*L\n45#1:76,2\n62#1:79,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Sdk getSdkForFile(Project project, Editor editor2) {
            Object v3;
            block4: {
                Editor editor3 = editor2;
                if (editor3 == null || (editor3 = editor3.getDocument()) == null) {
                    return null;
                }
                Editor document = editor3;
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile((Document)document);
                PsiFile psiFile2 = psiFile;
                if (psiFile2 == null || (psiFile2 = psiFile2.getViewProvider()) == null) {
                    return null;
                }
                PsiFile viewProvider = psiFile2;
                List list = viewProvider.getAllFiles();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllFiles(...)");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiFile it = (PsiFile)element$iv;
                    boolean bl = false;
                    if (!(it instanceof PyFile)) continue;
                    v3 = element$iv;
                    break block4;
                }
                v3 = null;
            }
            PsiFile psiFile = v3;
            if (psiFile == null) {
                return null;
            }
            PsiFile pyPsiFile = psiFile;
            return PythonSdkUtil.findPythonSdk((PsiElement)((PsiElement)pyPsiFile));
        }

        static /* synthetic */ Sdk getSdkForFile$default(Companion companion, Project project, Editor editor2, int n, Object object) {
            if ((n & 2) != 0) {
                editor2 = null;
            }
            return companion.getSdkForFile(project, editor2);
        }

        @Nullable
        public final Sdk getSdk(@NotNull Project project, @Nullable Editor editor2) {
            Sdk sdk2;
            block3: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                sdk2 = (Sdk)ActionsKt.runReadAction(() -> Companion.getSdk$lambda$0(project, editor2));
                if (sdk2 == null && (sdk2 = PySdkExtKt.getPythonSdk(project)) == null) {
                    for (Module it : ProjectUtil.getModules((Project)project)) {
                        boolean bl = false;
                        sdk2 = PySdkExtKt.getPythonSdk(it);
                        if (sdk2 == null) {
                            continue;
                        }
                        break block3;
                    }
                    sdk2 = null;
                }
            }
            return sdk2;
        }

        public static /* synthetic */ Sdk getSdk$default(Companion companion, Project project, Editor editor2, int n, Object object) {
            if ((n & 2) != 0) {
                editor2 = null;
            }
            return companion.getSdk(project, editor2);
        }

        @Nullable
        public final Pair<Sdk, String> getInstallablePackageName(@NotNull Project project, @Nullable EditorImpl editor2, @NotNull String line) {
            boolean isCanBeInstalled;
            String string;
            block4: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                String prefix = "ModuleNotFoundError: No module named '";
                if (!StringsKt.startsWith$default((String)line, (String)prefix, (boolean)false, (int)2, null)) {
                    return null;
                }
                String $this$dropLastWhile$iv = StringsKt.removePrefix((String)line, (CharSequence)prefix);
                boolean $i$f$dropLastWhile = false;
                for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv); -1 < index$iv; --index$iv) {
                    char it22 = $this$dropLastWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (it22 != '\'') continue;
                    String it22 = $this$dropLastWhile$iv;
                    int n = 0;
                    int n2 = index$iv + 1;
                    String string2 = it22.substring(n, n2);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    break block4;
                }
                string = "";
            }
            String moduleName = StringsKt.dropLast((String)string, (int)1);
            Sdk sdk2 = this.getSdk(project, (Editor)editor2);
            if (sdk2 == null) {
                return null;
            }
            Sdk pythonSdk = sdk2;
            PythonPackageManager packageManager2 = PythonPackageManager.Companion.forSdk(project, pythonSdk);
            String packageName = PyPsiPackageUtil.moduleToPackageName$default((PyPsiPackageUtil)PyPsiPackageUtil.INSTANCE, (String)moduleName, null, (int)2, null);
            boolean bl = isCanBeInstalled = !PySdkExtKt.isReadOnly(pythonSdk) && PythonPackageManagerExt.isNotInstalledAndCanBeInstalled$default(packageManager2, packageName, null, 2, null);
            if (!isCanBeInstalled) {
                return null;
            }
            return TuplesKt.to((Object)pythonSdk, (Object)packageName);
        }

        private static final Sdk getSdk$lambda$0(Project $project, Editor $editor) {
            return Companion.getSdkForFile($project, $editor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

