/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ngram.slp.counting.giga;

import com.intellij.completion.ngram.slp.counting.Counter;
import com.intellij.completion.ngram.slp.counting.trie.AbstractTrie;
import com.intellij.completion.ngram.slp.counting.trie.MapTrieCounter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class VirtualCounter
implements Counter {
    private static final long serialVersionUID = 8266734684040886875L;
    private List<MapTrieCounter> counters;
    private long memCC = 0L;
    private int memSC = 0;
    private int[] memDS = null;

    public VirtualCounter() {
        this(1);
    }

    public VirtualCounter(int counters) {
        this(IntStream.range(0, counters).mapToObj(i -> new MapTrieCounter()).collect(Collectors.toList()));
    }

    public VirtualCounter(List<MapTrieCounter> counters) {
        this.counters = counters;
    }

    @Override
    public int getCount() {
        return this.counters.get(0).getCount();
    }

    @Override
    public long[] getCounts(List<Integer> indices) {
        long[] counts = this.getCounter(indices).getCounts(indices);
        if (indices.size() == 1) {
            if (this.memCC == 0L) {
                this.memCC = this.counters.stream().mapToInt(AbstractTrie::getContextCount).sum();
            }
            counts[1] = this.memCC;
        }
        return counts;
    }

    @Override
    public int getCountOfCount(int n, int count) {
        return this.counters.get(0).getCountOfCount(n, count);
    }

    @Override
    public int getSuccessorCount() {
        if (this.memSC == 0) {
            this.memSC = this.counters.stream().mapToInt(Counter::getSuccessorCount).sum();
        }
        return this.memSC;
    }

    @Override
    public int getSuccessorCount(List<Integer> indices) {
        return this.getCounter(indices).getSuccessorCount(indices);
    }

    @Override
    public List<Integer> getTopSuccessors(List<Integer> indices, int limit) {
        if (!indices.isEmpty()) {
            return this.getCounter(indices).getTopSuccessors(indices, limit);
        }
        return this.getCounter(indices).getTopSuccessors(indices, limit);
    }

    @Override
    public int[] getDistinctCounts(int range, List<Integer> indices) {
        if (indices.isEmpty()) {
            if (this.memDS == null || this.memDS.length != range) {
                this.memDS = new int[range];
                this.counters.stream().map(c -> c.getDistinctCounts(range, indices)).forEach(d -> IntStream.range(0, ((int[])d).length).forEach(j -> {
                    int n = j;
                    this.memDS[n] = this.memDS[n] + d[j];
                }));
            }
            return this.memDS;
        }
        return this.getCounter(indices).getDistinctCounts(range, indices);
    }

    @Override
    public void count(List<Integer> indices) {
        this.memCC = 0L;
        this.memSC = 0;
        this.memDS = null;
        this.getCounter(indices).count(indices);
    }

    public void count(List<Integer> indices, int frequency) {
        this.memCC = 0L;
        this.memSC = 0;
        this.memDS = null;
        this.getCounter(indices).update(indices, frequency);
    }

    @Override
    public void unCount(List<Integer> indices) {
        this.memCC = 0L;
        this.memSC = 0;
        this.memDS = null;
        this.getCounter(indices).unCount(indices);
    }

    private MapTrieCounter getCounter(List<Integer> indices) {
        return this.counters.get(this.getIndex(indices));
    }

    private int getIndex(List<Integer> key) {
        return key.isEmpty() ? 0 : key.get(0) % this.counters.size();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.counters.size());
        for (MapTrieCounter counter : this.counters) {
            counter.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.counters.clear();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            MapTrieCounter counter = new MapTrieCounter(0);
            counter.readExternal(in);
            this.counters.add(counter);
        }
    }
}

