/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;

public class OboUtilities {
    private static final Pattern OBO_ID_PATTERN = Pattern.compile("(([A-Z]|[a-z])+(_([A-Z]|[a-z])+)?):(\\d+)");
    private static final String OBO_LIBRARY_IRI_BASE = "http://purl.obolibrary.org/obo/";
    private static final Pattern OBO_ID_IRI_PATTERN = Pattern.compile("/(([A-Z]|[a-z])+(_([A-Z]|[a-z])+)?)_(\\d+)$");
    private static final int ID_SPACE_GROUP = 1;
    private static final int LOCAL_ID_GROUP = 5;

    public static boolean isOboId(@Nonnull String value) {
        return OBO_ID_PATTERN.matcher((CharSequence)Preconditions.checkNotNull((Object)value)).matches();
    }

    public static boolean isOboIri(@Nonnull IRI iri) {
        return OBO_ID_IRI_PATTERN.matcher(iri.toString()).find();
    }

    @Nonnull
    public static IRI getOboLibraryIriFromOboId(@Nonnull String oboId) {
        Matcher matcher = OBO_ID_PATTERN.matcher((CharSequence)Preconditions.checkNotNull((Object)oboId));
        if (!matcher.matches()) {
            throw new RuntimeException("Invalid OBO Id: " + oboId);
        }
        MatchResult matchResult = matcher.toMatchResult();
        return IRI.create((String)(OBO_LIBRARY_IRI_BASE + matchResult.group(1) + "_" + matchResult.group(5)));
    }

    @Nonnull
    public static Optional<String> getOboIdFromIri(@Nonnull IRI iri) {
        String iriString = iri.toString();
        Matcher matcher = OBO_ID_IRI_PATTERN.matcher(iriString);
        if (!matcher.find()) {
            return Optional.empty();
        }
        return Optional.of(matcher.group(1) + ":" + matcher.group(5));
    }
}

