/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model;

import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.Nonnull;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.SimpleIRIShortFormProvider;

public class OWLEditorKitIRIShortFormProvider
implements IRIShortFormProvider {
    private final OWLEditorKit editorKit;
    private final SimpleIRIShortFormProvider delegateIRIShortFormProvider;

    public OWLEditorKitIRIShortFormProvider(@Nonnull OWLEditorKit editorKit, @Nonnull SimpleIRIShortFormProvider delegateIRIShortFormProvider) {
        this.editorKit = (OWLEditorKit)((Object)Preconditions.checkNotNull((Object)((Object)editorKit)));
        this.delegateIRIShortFormProvider = (SimpleIRIShortFormProvider)Preconditions.checkNotNull((Object)delegateIRIShortFormProvider);
    }

    @Nonnull
    public String getShortForm(@Nonnull IRI iri) {
        OWLModelManager manager = this.editorKit.getOWLModelManager();
        Set entityWithIri = manager.getActiveOntology().getEntitiesInSignature(iri);
        if (entityWithIri.isEmpty()) {
            return this.delegateIRIShortFormProvider.getShortForm(iri);
        }
        return manager.getRendering((OWLObject)entityWithIri.iterator().next());
    }
}

