/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.GraphicsBox;
import org.scilab.forge.jlatexmath.ParseOption;
import org.scilab.forge.jlatexmath.ResizeAtom;
import org.scilab.forge.jlatexmath.RotateAtom;
import org.scilab.forge.jlatexmath.ScaleAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFormula;

public class GraphicsAtom
extends Atom {
    private Image image = null;
    private BufferedImage bimage;
    private Label c;
    private int w;
    private int h;
    private Atom base;
    private boolean first = true;
    private int interp = -1;

    public GraphicsAtom(String path, String option) {
        File f = new File(path);
        if (!f.exists()) {
            try {
                URL url = new URL(path);
                this.image = Toolkit.getDefaultToolkit().getImage(url);
            }
            catch (MalformedURLException e) {
                this.image = null;
            }
        } else {
            this.image = Toolkit.getDefaultToolkit().getImage(path);
        }
        if (this.image != null) {
            this.c = new Label();
            MediaTracker tracker = new MediaTracker(this.c);
            tracker.addImage(this.image, 0);
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException e) {
                this.image = null;
            }
        }
        this.draw();
        this.buildAtom(option);
    }

    protected void buildAtom(String option) {
        this.base = this;
        Map<String, String> options = ParseOption.parseMap(option);
        if (options.containsKey("width") || options.containsKey("height")) {
            this.base = new ResizeAtom(this.base, options.get("width"), options.get("height"), options.containsKey("keepaspectratio"));
        }
        if (options.containsKey("scale")) {
            double scl = Double.parseDouble(options.get("scale"));
            this.base = new ScaleAtom(this.base, scl, scl);
        }
        if (options.containsKey("angle") || options.containsKey("origin")) {
            this.base = new RotateAtom(this.base, options.get("angle"), options.get("origin"));
        }
        if (options.containsKey("interpolation")) {
            String meth = options.get("interpolation");
            if (meth.equalsIgnoreCase("bilinear")) {
                this.interp = 0;
            } else if (meth.equalsIgnoreCase("bicubic")) {
                this.interp = 2;
            } else if (meth.equalsIgnoreCase("nearest_neighbor")) {
                this.interp = 1;
            }
        }
    }

    public void draw() {
        if (this.image != null) {
            this.w = this.image.getWidth(this.c);
            this.h = this.image.getHeight(this.c);
            this.bimage = new BufferedImage(this.w, this.h, 2);
            Graphics2D g2d = this.bimage.createGraphics();
            g2d.drawImage(this.image, 0, 0, null);
            g2d.dispose();
        }
    }

    public Box createBox(TeXEnvironment env) {
        if (this.image != null) {
            if (this.first) {
                this.first = false;
                return this.base.createBox(env);
            }
            env.isColored = true;
            float width = (float)this.w * SpaceAtom.getFactor(2, env);
            float height = (float)this.h * SpaceAtom.getFactor(2, env);
            return new GraphicsBox(this.bimage, width, height, env.getSize(), this.interp);
        }
        return new TeXFormula((String)"\\text{ No such image file ! }").root.createBox(env);
    }
}

