/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileGroup;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.decoration.symbol.USymbols;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandPartition3
extends SingleLineCommand2<ActivityDiagram3> {
    public CommandPartition3() {
        super(CommandPartition3.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandPartition3.class.getName(), RegexLeaf.start(), new RegexLeaf(1, "TYPE", "(partition|package|rectangle|card|group)"), RegexLeaf.spaceOneOrMore(), new RegexOptional((IRegex)new RegexConcat(CommandPartition3.color("BACK1").getRegex(), RegexLeaf.spaceOneOrMore())), new RegexLeaf(1, "NAME", "([%g][^%g]+[%g]|.*?)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), CommandPartition3.color("BACK2").getRegex())), StereotypePattern.optional("STEREO"), new RegexLeaf("\\{?"), RegexLeaf.end());
    }

    private USymbol getUSymbol(String type) {
        if ("partition".equalsIgnoreCase(type)) {
            return USymbols.PARTITION;
        }
        if ("package".equalsIgnoreCase(type)) {
            return USymbols.PACKAGE;
        }
        if ("rectangle".equalsIgnoreCase(type)) {
            return USymbols.RECTANGLE;
        }
        if ("card".equalsIgnoreCase(type)) {
            return USymbols.CARD;
        }
        if ("group".equalsIgnoreCase(type)) {
            return USymbols.GROUP;
        }
        throw new IllegalArgumentException();
    }

    private static ColorParser color(String id) {
        return ColorParser.simpleColor(ColorType.BACK, id);
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram3 diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String partitionTitle = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("NAME", 0));
        String b1 = arg.get("BACK1", 0);
        Colors colors = CommandPartition3.color(b1 == null ? "BACK2" : "BACK1").getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        USymbol symbol = this.getUSymbol(arg.get("TYPE", 0));
        String stereo = arg.get("STEREO", 0);
        Stereotype stereotype = stereo == null ? null : Stereotype.build(stereo);
        Style stylePartition = FtileGroup.getStyleSignature(symbol).withTOBECHANGED(stereotype).getMergedStyle(diagram.getSkinParam().getCurrentStyleBuilder());
        HColor backColor = colors.getColor(ColorType.BACK);
        if (backColor == null) {
            backColor = stylePartition.value(PName.BackGroundColor).asColor(diagram.getSkinParam().getIHtmlColorSet());
        }
        diagram.startGroup(Display.getWithNewlines(diagram.getPragma(), partitionTitle), backColor, symbol, stylePartition);
        return CommandExecutionResult.ok();
    }
}

