/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.configuration;

import com.google.common.annotations.VisibleForTesting;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.common.settings.Settings;

public class Salt {
    private static final Logger log = LogManager.getLogger(Salt.class);
    @VisibleForTesting
    static final int SALT_SIZE = 16;
    private final byte[] salt16;

    public Salt(byte[] salt) {
        if (salt.length != 16) {
            throw new OpenSearchException("Provided compliance salt must contain 16 bytes", new Object[0]);
        }
        this.salt16 = salt;
    }

    private Salt(String saltAsString) {
        this.salt16 = new byte[16];
        if (saltAsString.equals("e1ukloTsQlOgPquJ")) {
            log.warn("If you plan to use field masking pls configure compliance salt {} to be a random string of 16 chars length identical on all nodes", (Object)saltAsString);
        }
        try {
            ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(saltAsString);
            byteBuffer.get(this.salt16);
            if (byteBuffer.remaining() > 0) {
                log.warn("Provided compliance salt {} is greater than 16 bytes. Only the first 16 bytes are used for salting", (Object)saltAsString);
            }
        }
        catch (BufferUnderflowException e) {
            throw new OpenSearchException("Provided compliance salt " + saltAsString + " must at least contain 16 bytes", (Throwable)e, new Object[0]);
        }
    }

    public byte[] getSalt16() {
        return this.salt16;
    }

    public static Salt from(Settings settings) {
        String saltAsString = settings.get("plugins.security.compliance.salt", "e1ukloTsQlOgPquJ");
        return new Salt(saltAsString);
    }
}

