/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest.simulate;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Document
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Document> {
    @Nullable
    private final String id;
    @Nullable
    private final String index;
    @Nonnull
    private final JsonData source;
    public static final JsonpDeserializer<Document> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Document::setupDocumentDeserializer);

    private Document(Builder builder) {
        this.id = builder.id;
        this.index = builder.index;
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
    }

    public static Document of(Function<Builder, ObjectBuilder<Document>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nonnull
    public final JsonData source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("_id");
            generator.write(this.id);
        }
        if (this.index != null) {
            generator.writeKey("_index");
            generator.write(this.index);
        }
        generator.writeKey("_source");
        this.source.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDocumentDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::source, JsonData._DESERIALIZER, "_source");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + this.source.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document other = (Document)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.index, other.index) && this.source.equals(other.source);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Document> {
        @Nullable
        private String id;
        @Nullable
        private String index;
        private JsonData source;

        public Builder() {
        }

        private Builder(Document o) {
            this.id = o.id;
            this.index = o.index;
            this.source = o.source;
        }

        private Builder(Builder o) {
            this.id = o.id;
            this.index = o.index;
            this.source = o.source;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder source(JsonData value) {
            this.source = value;
            return this;
        }

        @Override
        @Nonnull
        public Document build() {
            this._checkSingleUse();
            return new Document(this);
        }
    }
}

