/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.KeyRingIterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPMarker;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPadding;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Iterable;
import org.bouncycastle.util.Longs;
import org.bouncycastle.util.Strings;

public class PGPSecretKeyRingCollection
implements Iterable<PGPSecretKeyRing> {
    private Map<Long, PGPSecretKeyRing> secretRings = new HashMap<Long, PGPSecretKeyRing>();
    private List<Long> order = new ArrayList<Long>();

    private PGPSecretKeyRingCollection(Map<Long, PGPSecretKeyRing> secretRings, List<Long> order) {
        this.secretRings = secretRings;
        this.order = order;
    }

    public PGPSecretKeyRingCollection(byte[] encoding, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        this(new ByteArrayInputStream(encoding), fingerPrintCalculator);
    }

    public PGPSecretKeyRingCollection(InputStream in, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        Object obj;
        PGPObjectFactory pgpFact = new PGPObjectFactory(in, fingerPrintCalculator);
        while ((obj = pgpFact.nextObject()) != null) {
            if (obj instanceof PGPMarker || obj instanceof PGPPadding) continue;
            if (!(obj instanceof PGPSecretKeyRing)) {
                throw new PGPException(obj.getClass().getName() + " found where PGPSecretKeyRing expected");
            }
            PGPSecretKeyRing pgpSecret = (PGPSecretKeyRing)obj;
            Long key = Longs.valueOf((long)pgpSecret.getPublicKey().getKeyID());
            this.secretRings.put(key, pgpSecret);
            this.order.add(key);
        }
    }

    public PGPSecretKeyRingCollection(Collection<PGPSecretKeyRing> collection) {
        for (PGPSecretKeyRing pgpSecret : collection) {
            Long key = Longs.valueOf((long)pgpSecret.getPublicKey().getKeyID());
            this.secretRings.put(key, pgpSecret);
            this.order.add(key);
        }
    }

    public int size() {
        return this.order.size();
    }

    public Iterator<PGPSecretKeyRing> getKeyRings() {
        return this.secretRings.values().iterator();
    }

    public Iterator<PGPSecretKeyRing> getKeyRings(String userID) {
        return this.getKeyRings(userID, false, false);
    }

    public Iterator<PGPSecretKeyRing> getKeyRings(String userID, boolean matchPartial) {
        return this.getKeyRings(userID, matchPartial, false);
    }

    public Iterator<PGPSecretKeyRing> getKeyRings(String userID, boolean matchPartial, boolean ignoreCase) {
        Iterator<PGPSecretKeyRing> it = this.getKeyRings();
        ArrayList<PGPSecretKeyRing> rings = new ArrayList<PGPSecretKeyRing>();
        if (ignoreCase) {
            userID = Strings.toLowerCase((String)userID);
        }
        while (it.hasNext()) {
            PGPSecretKeyRing secRing = it.next();
            Iterator<String> uIt = secRing.getSecretKey().getUserIDs();
            while (uIt.hasNext()) {
                String next = uIt.next();
                if (ignoreCase) {
                    next = Strings.toLowerCase((String)next);
                }
                if (matchPartial) {
                    if (next.indexOf(userID) < 0) continue;
                    rings.add(secRing);
                    continue;
                }
                if (!next.equals(userID)) continue;
                rings.add(secRing);
            }
        }
        return rings.iterator();
    }

    public PGPSecretKey getSecretKey(long keyID) {
        Iterator<PGPSecretKeyRing> it = this.getKeyRings();
        while (it.hasNext()) {
            PGPSecretKeyRing secRing = it.next();
            PGPSecretKey sec = secRing.getSecretKey(keyID);
            if (sec == null) continue;
            return sec;
        }
        return null;
    }

    public PGPSecretKeyRing getSecretKeyRing(long keyID) {
        Long id = Longs.valueOf((long)keyID);
        if (this.secretRings.containsKey(id)) {
            return this.secretRings.get(id);
        }
        Iterator<PGPSecretKeyRing> it = this.getKeyRings();
        while (it.hasNext()) {
            PGPSecretKeyRing secretRing = it.next();
            PGPSecretKey secret = secretRing.getSecretKey(keyID);
            if (secret == null) continue;
            return secretRing;
        }
        return null;
    }

    public boolean contains(long keyID) {
        return this.getSecretKey(keyID) != null;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        BCPGOutputStream out = BCPGOutputStream.wrap(outStream);
        Iterator<Long> it = this.order.iterator();
        while (it.hasNext()) {
            PGPSecretKeyRing sr = this.secretRings.get(it.next());
            sr.encode(out);
        }
    }

    public static PGPSecretKeyRingCollection addSecretKeyRing(PGPSecretKeyRingCollection ringCollection, PGPSecretKeyRing secretKeyRing) {
        Long key = Longs.valueOf((long)secretKeyRing.getPublicKey().getKeyID());
        if (ringCollection.secretRings.containsKey(key)) {
            throw new IllegalArgumentException("Collection already contains a key with a keyID for the passed in ring.");
        }
        HashMap<Long, PGPSecretKeyRing> newSecretRings = new HashMap<Long, PGPSecretKeyRing>(ringCollection.secretRings);
        ArrayList<Long> newOrder = new ArrayList<Long>(ringCollection.order);
        newSecretRings.put(key, secretKeyRing);
        newOrder.add(key);
        return new PGPSecretKeyRingCollection(newSecretRings, newOrder);
    }

    public static PGPSecretKeyRingCollection removeSecretKeyRing(PGPSecretKeyRingCollection ringCollection, PGPSecretKeyRing secretKeyRing) {
        Long key = Longs.valueOf((long)secretKeyRing.getPublicKey().getKeyID());
        if (!ringCollection.secretRings.containsKey(key)) {
            throw new IllegalArgumentException("Collection does not contain a key with a keyID for the passed in ring.");
        }
        HashMap<Long, PGPSecretKeyRing> newSecretRings = new HashMap<Long, PGPSecretKeyRing>(ringCollection.secretRings);
        ArrayList<Long> newOrder = new ArrayList<Long>(ringCollection.order);
        newSecretRings.remove(key);
        for (int i = 0; i < newOrder.size(); ++i) {
            Long r = (Long)newOrder.get(i);
            if (r.longValue() != key.longValue()) continue;
            newOrder.remove(i);
            break;
        }
        return new PGPSecretKeyRingCollection(newSecretRings, newOrder);
    }

    public Iterator<PGPSecretKeyRing> iterator() {
        return new KeyRingIterator<PGPSecretKeyRing>(this.order, this.secretRings);
    }
}

