/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.util.function.Predicate;

public class Predicates {
    public static final Predicate NONE = p -> false;
    public static final Predicate EVERY = p -> true;

    public static final <T> Predicate<T> not(Predicate<T> other) {
        return p -> !other.test(p);
    }

    public static final <T> Predicate<T> and(Predicate<T> ... params) {
        return p -> {
            boolean result = true;
            for (Predicate param : params) {
                boolean bl = result = result && param.test(p);
                if (!result) break;
            }
            return result;
        };
    }

    public static final <T> Predicate<T> or(Predicate<T> ... params) {
        return p -> {
            boolean result = false;
            for (Predicate param : params) {
                boolean bl = result = result || param.test(p);
                if (result) break;
            }
            return result;
        };
    }
}

