/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.graph;

import java.util.Locale;

public enum GraphSemantic {
    FETCH,
    LOAD;


    public String getJakartaHintName() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "jakarta.persistence.fetchgraph";
            case 1 -> "jakarta.persistence.loadgraph";
        };
    }

    @Deprecated(since="6.0")
    public String getJpaHintName() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "javax.persistence.fetchgraph";
            case 1 -> "javax.persistence.loadgraph";
        };
    }

    public static GraphSemantic fromHintName(String hintName) {
        return switch (hintName) {
            case "jakarta.persistence.fetchgraph", "javax.persistence.fetchgraph" -> FETCH;
            case "jakarta.persistence.loadgraph", "javax.persistence.loadgraph" -> LOAD;
            default -> throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown EntityGraph hint name - `%s`.  Expecting `%s` or `%s` (or `%s` and `%s`).", hintName, "jakarta.persistence.fetchgraph", "jakarta.persistence.loadgraph", "javax.persistence.fetchgraph", "javax.persistence.loadgraph"));
        };
    }
}

