/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Collections;
import java.util.List;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class ListaggFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final String emptyWithinReplacement;

    public ListaggFunction(String emptyWithinReplacement, TypeConfiguration typeConfiguration) {
        super("listagg", FunctionKind.ORDERED_SET_AGGREGATE, new ArgumentTypesValidator(StandardArgumentsValidators.exactly(2), FunctionParameterType.STRING, FunctionParameterType.STRING), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.STRING, FunctionParameterType.STRING));
        this.emptyWithinReplacement = emptyWithinReplacement;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, sqlAstArguments, null, Collections.emptyList(), returnType, walker);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, sqlAstArguments, filter, Collections.emptyList(), returnType, walker);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, List<SortSpecification> withinGroup, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        Expression arg;
        boolean caseWrapper = filter != null && !ListaggFunction.filterClauseSupported(translator);
        sqlAppender.appendSql("listagg(");
        SqlAstNode firstArg = sqlAstArguments.get(0);
        if (firstArg instanceof Distinct) {
            Distinct distinct = (Distinct)firstArg;
            sqlAppender.appendSql("distinct ");
            arg = distinct.getExpression();
        } else {
            arg = (Expression)firstArg;
        }
        if (caseWrapper) {
            sqlAppender.appendSql("case when ");
            translator.getCurrentClauseStack().push(Clause.WHERE);
            filter.accept(translator);
            translator.getCurrentClauseStack().pop();
            sqlAppender.appendSql(" then ");
            arg.accept(translator);
            sqlAppender.appendSql(" else null end");
        } else {
            arg.accept(translator);
        }
        if (sqlAstArguments.size() != 1) {
            sqlAppender.appendSql(',');
            sqlAstArguments.get(1).accept(translator);
        }
        sqlAppender.appendSql(')');
        if (withinGroup != null && !withinGroup.isEmpty()) {
            translator.getCurrentClauseStack().push(Clause.WITHIN_GROUP);
            sqlAppender.appendSql(" within group (order by ");
            withinGroup.get(0).accept(translator);
            for (int i = 1; i < withinGroup.size(); ++i) {
                sqlAppender.appendSql(',');
                withinGroup.get(i).accept(translator);
            }
            sqlAppender.appendSql(')');
            translator.getCurrentClauseStack().pop();
        } else if (this.emptyWithinReplacement != null) {
            sqlAppender.appendSql(' ');
            sqlAppender.appendSql(this.emptyWithinReplacement);
        }
        if (!caseWrapper && filter != null) {
            translator.getCurrentClauseStack().push(Clause.WHERE);
            sqlAppender.appendSql(" filter (where ");
            filter.accept(translator);
            sqlAppender.appendSql(')');
            translator.getCurrentClauseStack().pop();
        }
    }
}

