/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Collections;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.impl.BaseRpcInterceptor;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.transport.impl.VoidResponseCollector;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Invalidation", description="Component responsible for invalidating entries on remote caches when entries are written to locally.")
public class InvalidationInterceptor
extends BaseRpcInterceptor
implements JmxStatisticsExposer {
    private static final Log log = LogFactory.getLog(InvalidationInterceptor.class);
    private final AtomicLong invalidations = new AtomicLong(0L);
    private final InvocationSuccessFunction<CommitCommand> handleCommit = this::handleCommit;
    private final InvocationSuccessFunction<PrepareCommand> handlePrepare = this::handlePrepare;
    @Inject
    CommandsFactory commandsFactory;
    private boolean statisticsEnabled;

    @Override
    protected Log getLog() {
        return log;
    }

    @Start
    void start() {
        this.setStatisticsEnabled(this.cacheConfiguration.statistics().enabled());
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        if (!this.isPutForExternalRead(command)) {
            return this.handleInvalidate(ctx, command, command.getKey());
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
        return this.handleInvalidate(ctx, command, command.getKey());
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) {
        return this.handleInvalidate(ctx, command, command.getKey());
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) {
        return this.handleInvalidate(ctx, command, command.getKey());
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        return this.handleInvalidate(ctx, command, command.getKey());
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) {
        return this.invokeNextThenApply(ctx, command, (rCtx, clearCommand, rv) -> {
            if (!this.isLocalModeForced((FlagAffectedCommand)clearCommand) && rCtx.isOriginLocal()) {
                clearCommand.setTopologyId(this.rpcManager.getTopologyId());
                CompletionStage<Void> remoteInvocation = this.rpcManager.invokeCommandOnAll(clearCommand, VoidResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
                return InvalidationInterceptor.asyncValue(remoteInvocation);
            }
            return rv;
        });
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
        Object[] keys = command.getMap() == null ? null : command.getMap().keySet().toArray();
        return this.handleInvalidate(ctx, command, keys);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) {
        return this.invokeNextThenApply(ctx, command, this.handlePrepare);
    }

    private Object handlePrepare(InvocationContext ctx, PrepareCommand prepareCommand, Object rv) {
        TxInvocationContext txInvocationContext = (TxInvocationContext)ctx;
        if (!this.shouldInvokeRemoteTxCommand(txInvocationContext)) {
            log.tracef("Nothing to invalidate - no modifications in the transaction.", new Object[0]);
            return rv;
        }
        if (txInvocationContext.getTransaction() == null) {
            throw new IllegalStateException("We must have an associated transaction");
        }
        Object[] keys = prepareCommand.getModifications().stream().filter(InvalidationInterceptor::flagCacheModeLocalNotSet).filter(InvalidationInterceptor::writeCommandIsNotPutForExternalRead).map(WriteCommand::getAffectedKeys).mapMulti(Iterable::forEach).toArray();
        if (keys.length == 0) {
            return rv;
        }
        CompletionStage<Void> remoteInvocation = this.invalidateAcrossCluster(txInvocationContext, keys, this.defaultSynchronous, prepareCommand.isOnePhaseCommit(), prepareCommand.getTopologyId());
        return InvalidationInterceptor.asyncValue(remoteInvocation.handle((responses, t) -> {
            if (t == null) {
                return null;
            }
            log.unableToRollbackInvalidationsDuringPrepare((Throwable)t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException("Unable to broadcast invalidation messages", (Throwable)t);
        }));
    }

    private static boolean flagCacheModeLocalNotSet(FlagAffectedCommand cmd) {
        return !cmd.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL);
    }

    private static boolean writeCommandIsNotPutForExternalRead(WriteCommand cmd) {
        return !cmd.hasAnyFlag(FlagBitSets.PUT_FOR_EXTERNAL_READ) || !(cmd instanceof PutKeyValueCommand);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) {
        if (!this.shouldInvokeRemoteTxCommand(ctx)) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenApply(ctx, command, this.handleCommit);
    }

    private Object handleCommit(InvocationContext ctx, CommitCommand command, Object ignored) {
        try {
            CompletionStage<Void> remoteInvocation = this.rpcManager.invokeCommandOnAll(command, VoidResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
            return InvalidationInterceptor.asyncValue(remoteInvocation);
        }
        catch (Throwable t) {
            throw this.wrapException(t);
        }
    }

    private RuntimeException wrapException(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return log.unableToBroadcastInvalidation(t);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenApply(ctx, command, (rCtx, lockControlCommand, rv) -> {
            boolean sync = !lockControlCommand.isUnlock();
            ((LocalTxInvocationContext)rCtx).remoteLocksAcquired(this.rpcManager.getTransport().getMembers());
            if (sync) {
                CompletionStage<Void> remoteInvocation = this.rpcManager.invokeCommandOnAll(lockControlCommand, VoidResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
                return InvalidationInterceptor.asyncValue(remoteInvocation);
            }
            this.rpcManager.sendToAll(lockControlCommand, DeliverOrder.PER_SENDER);
            return null;
        });
    }

    private Object handleInvalidate(InvocationContext ctx, WriteCommand command, Object ... keys) {
        if (ctx.isInTxScope()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenApply(ctx, command, (rCtx, writeCommand, rv) -> {
            if (writeCommand.isSuccessful() && keys != null && keys.length != 0 && !this.isLocalModeForced((FlagAffectedCommand)writeCommand)) {
                int topologyId = this.rpcManager.getTopologyId();
                CompletionStage<Void> remoteInvocation = this.invalidateAcrossCluster(rCtx, keys, this.isSynchronous((FlagAffectedCommand)writeCommand), true, topologyId);
                return InvalidationInterceptor.asyncValue(remoteInvocation.thenApply(responses -> rv));
            }
            return rv;
        });
    }

    private CompletionStage<Void> invalidateAcrossCluster(InvocationContext ctx, Object[] keys, boolean synchronous, boolean onePhaseCommit, int topologyId) {
        InvalidateCommand invalidateCommand;
        this.incrementInvalidations();
        RemoteLockCommand command = invalidateCommand = this.commandsFactory.buildInvalidateCommand(0L, keys);
        if (ctx.isInTxScope()) {
            TxInvocationContext txCtx = (TxInvocationContext)ctx;
            command = this.commandsFactory.buildPrepareCommand(txCtx.getGlobalTransaction(), Collections.singletonList(invalidateCommand), onePhaseCommit);
        }
        command.setTopologyId(topologyId);
        if (synchronous) {
            return this.rpcManager.invokeCommandOnAll(command, VoidResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
        }
        this.rpcManager.sendToAll(command, DeliverOrder.NONE);
        return CompletableFutures.completedNull();
    }

    private void incrementInvalidations() {
        if (this.statisticsEnabled) {
            this.invalidations.incrementAndGet();
        }
    }

    private boolean isPutForExternalRead(FlagAffectedCommand command) {
        if (command.hasAnyFlag(FlagBitSets.PUT_FOR_EXTERNAL_READ)) {
            log.trace("Put for external read called.  Suppressing clustered invalidation.");
            return true;
        }
        return false;
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        this.invalidations.set(0L);
    }

    @Override
    @ManagedAttribute(displayName="Statistics enabled", description="Enables or disables the gathering of statistics by this component", dataType=DataType.TRAIT, writable=true)
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    @ManagedAttribute(description="Number of invalidations", displayName="Number of invalidations", measurementType=MeasurementType.TRENDSUP)
    public long getInvalidations() {
        return this.invalidations.get();
    }
}

