/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.RejectedExecutionException;

public class MultiSubscribeOnOp<T>
extends AbstractMultiOperator<T, T> {
    private final Executor executor;

    public MultiSubscribeOnOp(Multi<? extends T> upstream, Executor executor) {
        super(upstream);
        this.executor = ParameterValidation.nonNull(executor, "executor");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        SubscribeOnProcessor<? super T> sub = new SubscribeOnProcessor<T>(downstream, this.executor);
        sub.scheduleSubscription(this.upstream, downstream);
    }

    static final class SubscribeOnProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final Executor executor;

        SubscribeOnProcessor(MultiSubscriber<? super T> downstream, Executor executor) {
            super(downstream);
            this.executor = executor;
        }

        public void scheduleSubscription(Multi<? extends T> upstream, MultiSubscriber<? super T> downstream) {
            try {
                this.executor.execute(() -> upstream.subscribe().withSubscriber(this));
            }
            catch (RejectedExecutionException rejection) {
                this.onFailure(rejection);
            }
        }

        @Override
        public void request(long numberOfItems) {
            if (numberOfItems <= 0L) {
                this.onFailure(new IllegalArgumentException("Invalid number of request, must be greater than 0"));
                return;
            }
            if (!this.isDone()) {
                try {
                    this.executor.execute(() -> {
                        Flow.Subscription subscription = this.getUpstreamSubscription();
                        if (subscription != Subscriptions.CANCELLED) {
                            subscription.request(numberOfItems);
                        }
                    });
                }
                catch (RejectedExecutionException rejected) {
                    this.onFailure(rejected);
                }
            }
        }
    }
}

