/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

public enum LaunchMode {
    NORMAL("prod", "quarkus.profile", false, false),
    RUN("prod", "quarkus.profile", true, false),
    DEVELOPMENT("dev", "quarkus.profile", true, true),
    TEST("test", "quarkus.test.profile", true, true);

    public static final String DEV_PROFILE = "dev";
    public static final String PROD_PROFILE = "prod";
    public static final String TEST_PROFILE = "test";
    private final String defaultProfile;
    private final String profileKey;
    private final boolean devServicesSupported;
    private final boolean liveReloadSupported;
    private static volatile LaunchMode launchMode;

    private LaunchMode(String defaultProfile, String profileKey, boolean devServicesSupported, boolean liveReloadSupported) {
        this.defaultProfile = defaultProfile;
        this.profileKey = profileKey;
        this.devServicesSupported = devServicesSupported;
        this.liveReloadSupported = liveReloadSupported;
    }

    public String getDefaultProfile() {
        return this.defaultProfile;
    }

    public String getProfileKey() {
        return this.profileKey;
    }

    public boolean isDev() {
        return this == DEVELOPMENT;
    }

    public boolean isRemoteDev() {
        return this == DEVELOPMENT && "true".equals(System.getenv("QUARKUS_LAUNCH_DEVMODE"));
    }

    public boolean isDevOrTest() {
        return this == DEVELOPMENT || this == TEST;
    }

    public boolean isProduction() {
        return PROD_PROFILE.equals(this.getDefaultProfile());
    }

    public boolean isDevServicesSupported() {
        return this.devServicesSupported;
    }

    public boolean isDevResourcesSupported() {
        return this.devServicesSupported;
    }

    public boolean isLiveReloadSupported() {
        return this.liveReloadSupported;
    }

    public static void set(LaunchMode mode) {
        launchMode = mode;
    }

    public static LaunchMode current() {
        return launchMode;
    }

    static {
        launchMode = NORMAL;
    }
}

