/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.TreeMigration;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.PassiveToActive;
import ai.grazie.rules.en.PrepositionIssues;
import ai.grazie.rules.en.PronounForm;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.StyleRules;
import ai.grazie.rules.en.TagQuestions;
import ai.grazie.rules.en.WordConfusion;
import ai.grazie.rules.en.WordOrder;
import ai.grazie.rules.tree.CrazyParseDetector;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;

class EnglishCrazyParseDetector {
    private static final NodePattern aBut = NodePattern.N.inFormSequence(1, "a", "but");
    private static final NodePattern postIt = NodePattern.N.inFormSequence(1, "post", "its?");
    private static final NodePattern beingModifierClause = NodePattern.N.withDependent("cop|aux:pass", NodePattern.N.form("being"));
    private static final NodePattern havingModifierClause = NodePattern.N.withDependent("aux", NodePattern.N.form("having"));
    private static final NodePattern[] crazyParse = new NodePattern[]{NodePattern.N.withHead("cop|aux:pass", NodePattern.N.withDependent("advcl|parataxis", NodePattern.N.beforeHead().andNot(CommonPatterns.phraseEndsWithComma)).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl").withOptionalDependent("advcl", NodePattern.N.beforeHead()).withOptionalDependent("parataxis", NodePattern.N.beforeHead())).message("misparsed cop|aux:pass subj"), NodePattern.ROOT.withDependent("nsubj.*", NodePattern.N.afterHead()).withDependent("advcl", NodePattern.N.beforeHead()).noDependents("expl").message("advcl predicate subject"), NodePattern.N.withHead("obj", NodePattern.N.withHeadRelation("nsubj.*")).message("obj on nsubj"), NodePattern.N.withHead("case", NodePattern.N.withHead("nummod", NodePattern.N).noLemma("dozen|hundred|thousand|million|billion|(ga)?zillion").andNot(StyleRules.numOutOfNum).andNot(NodePattern.N.inFormSequence(2, "\\d+", "in", "\\d+").directlyBeforeHead())).message("case on nummod"), NodePattern.N.withHead("case", NodePattern.N.withHeadRelation("amod")).message("case on amod"), NodePattern.N.withHeadRelation("nummod").beforeHead().directlyBefore(CommonPatterns.comma).noDependents().message("nummod comma"), NodePattern.N.withHead("cop", NodePattern.N.withHead("advmod|nummod|expl", NodePattern.N).andOptionally(NodePattern.N.withPrevSibling(NodePattern.N))).message("cop on advmod|nummod|expl"), NodePattern.N.potentialPos("NNS").withHead("parataxis", NodePattern.N.pos("VB").noDependents(NodePattern.N.beforeHead()).noDependents("advmod")).noDependents("punct", CommonPatterns.DASH_NODE).withOptionalDependent("nsubj", NodePattern.N).message("imperative obj misparsed as parataxis"), NodePattern.N.withHead("cop|aux|aux:pass", NodePattern.N).withDependent(".*", NodePattern.not(EnglishTreePatterns.negation).andNot(CommonPatterns.comma).andNot(NodePattern.N.withHeadRelation("cop|aux|aux:pass"))).andNot(StyleRules.wanna).andNot(TagQuestions.possiblyTagQuestion).and((node, match) -> match.withTouchedNodes(node.allDependents())).message("aux with dependent"), NodePattern.N.pos("VB.*").noPos("MD").noLemma("do|have|be|let|hand").withHeadRelation("aux").message("plain verb as aux"), NodePattern.N.withHead("nsubj", NodePattern.N.withHeadRelation("nmod")).message("nsubj as child of nmod"), NodePattern.N.form("gentle|low").pos("V.*").noHeadRelation("advmod").message("Adjective incorrectly tagged as verb"), NodePattern.N.withHead("advcl", NodePattern.N).withDependent("cop|aux|aux:pass", CommonPatterns.firstChildPhrase).andNot(beingModifierClause).andNot(havingModifierClause).message("advcl started with aux"), NodePattern.N.pos("W.*").form("wh.*").afterHead().withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.N).withNextSibling(EnglishTreePatterns.clause.withHeadRelation("ccomp")).message("incorrect wh attachment"), NodePattern.N.form("which").withPrevSibling(NodePattern.N.withHead("obl", NodePattern.N.withHeadRelation("a(dv)?cl:relcl"))).message("non-first relativizer"), NodePattern.N.withHeadRelation("advmod").withNextSibling(NodePattern.N.pos("RBS")).message("advmod before RBS"), NodePattern.N.withHeadRelation("nsubj(:pass)?").withPrevSibling(NodePattern.N.form("to").withHeadRelation("mark")).andNot(PronounForm.whomever).message("to nsubj"), NodePattern.N.withHead("acl:relcl", NodePattern.N).andNot(EnglishTreePatterns.verbalClause).noDependents("cop|aux|aux:pass").andNot(NodePattern.N.withNeighbor(-2, PrepositionIssues.inNotAdj)).andNot(NodePattern.N.withDependent("nsubj", WordConfusion.itDirectlyBeforeHead)).andNot(NodePattern.N.pos("VBG").withDependent("nsubj", NodePattern.N.noPos("DT"))).andNot(NodePattern.N.potentialPos("VBD").withDependent("nsubj")).andNot(CommonPatterns.inParentheses).message("non-clause relcl"), NodePattern.N.withHead("acl:relcl", EnglishTreePatterns.clause.andNot(EnglishTreePatterns.unlikelyToBeVerb).withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.N)).message("relcl on a misparsed clause"), NodePattern.N.withHeadRelation("acl:relcl").beforeHead().message("pre-head acl:relcl"), NodePattern.N.withHeadRelation("acl:relcl").withDependent("aux:pass").withDependent("nsubj:pass").and(TreeMigration.revise("specific to tree-en?", NodePattern.N.withDependent("aux"))).noDependents(NodePattern.or(NodePattern.N.form("that"), Questions.whPhrase)).message("misparsed passive relcl"), NodePattern.N.withHead("nsubj|det", NodePattern.N).withDependent("case|fixed", NodePattern.not(StyleRules.incompleteEgIe).noForm("out")).noDependents("nummod", StyleRules.numOutOfNum).message("nsubj|det with case"), NodePattern.N.pos("W.*").withHead("case", NodePattern.N).message("wh case"), NodePattern.N.withHead("case", NodePattern.N).afterHead().pos("IN").noForm("through|to").andNot(NodePattern.N.inFormSequence(1, "look(ed|s)?", "like")).andOptionally(NodePattern.N.withDependent("fixed")).message("preposition after head"), NodePattern.N.form("how").withHead(NodePattern.N.withHeadRelation("advcl")).withPrevSibling(NodePattern.not(NodePattern.N.withHeadRelation("mark"))).message("advcl with how without another mark before it"), NodePattern.N.form("an?|the").withDependent("amod").message("amod on an article"), EnglishTreePatterns.nmodWithoutCase.noForm("[\\d/]+|la|(st|nd|rd|th)").afterHead().andNot(CommonPatterns.severalDependents("det")).andOptionally(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("nmod"))).andNot(Articles.prepositionsInNounCoordination).andNot(NodePattern.N.form("[\u00b4\u2032`;<>4\"!@#$%^&*()+,]s").directlyAfterHead()).andNot(NodePattern.N.withDependent("nmod|nummod", NodePattern.N.beforeHead().withDependent("case|mark"))).message("nmod without case|mark"), NodePattern.N.withHead("acl:relcl", NodePattern.not(Questions.whWord.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis")).andNot(StyleRules.whatcha)).withOnlyDependents(NodePattern.N.withHeadRelation("cop|aux|aux:pass")).message("relcl without args"), NodePattern.N.withHeadRelation("csubj:pass").andOr(NodePattern.N.pos("VB[ZD]").noDependents("mark").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?", Questions.whPhrase).message("finite clause misparsed as csubj:pass"), NodePattern.N.form("providing").withDependent("obj").message("providing [X is Y] parsed as providing [X] is Y")), NodePattern.N.withHead("cop|aux|aux:pass|nsubj", NodePattern.N.withHead("aux|cop|amod|nsubj.*|obj|obl.*", NodePattern.N.andOptionally(NodePattern.N.withHead("advmod", NodePattern.N))).andNot(StyleRules.wanna).andNot(WordOrder.headlessWhCopulaClause).andNot(TagQuestions.possiblyTagQuestion)).andNot(CommonPatterns.firstWord.lemma("be").withHead("cop", NodePattern.N.withHeadRelation("nsubj"))).andNot(WordConfusion.itDirectlyBeforeHead).message("aux.*|cop|nsubj on a non-clause"), NodePattern.N.withHead("det", NodePattern.N.withDependent("aux").noDependents("cop")).noDependents("punct", CommonPatterns.comma.afterHead()).message("det+aux"), NodePattern.N.form("that").withHead("mark", NodePattern.N.withHeadRelation("nsubj").potentialPos("VB").withDependent("compound", NodePattern.N.pos("NNS"))).message("that-csubj misparsed as nsubj"), NodePattern.N.form("be").withHead("advcl:relcl", NodePattern.N).message("be advcl:relcl"), NodePattern.N.withHead("ccomp", NodePattern.N).andOr(NodePattern.N.pos("VBZ"), NodePattern.N.pos("VBP").withDependent("mark", NodePattern.N.form("that")), NodePattern.N.withDependent("cop|aux|aux:pass", CommonPatterns.firstChildPhrase.pos("VBP"))).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations)).message("finite ccomp without subj"), NodePattern.N.markAs("First").andNot(Questions.whPhrase).andNot(StyleRules.whatcha).noForm("that|whether").withHead("obj|nummod", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.after("First")).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl", NodePattern.N.before("First")).andNot(NodePattern.N.withHead("ccomp", Semantics.directSpeech).and(CommonPatterns.insideQuotes))).message("obj|nummod before subj"), NodePattern.N.markAs("Subj").withHead("nsubj(:pass)?", NodePattern.N.after("Subj").and((predicate, match) -> {
        Node subject = match.getMarkedNode("Subj");
        return subject.nextUntil(predicate).anyMatch(n -> n.hasForm("[:\\]]") && !EnglishTreePatterns.noSpaceColon.matches((Node)n)) ? match : null;
    })).message("subj: predicate"), EnglishTreePatterns.severalSubjects.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.or(WordConfusion.lowercaseI, WordConfusion.aPart, PronounForm.whom, EnglishTreePatterns.duplicateVerbParsedAsSubj, PassiveToActive.expletiveIt, TagQuestions.pronounBeforeQuestion.afterHead(), NodePattern.N.withDependent("case", StyleRules.incompleteEgIe), NodePattern.N.withDependent("nsubj", PronounForm.whomever), NodePattern.N.label("PRODUCT").withDependent("punct", CommonPatterns.dot.noSpaceAround()))).andNot(NodePattern.N.withDependent("nsubj:outer").withDependent("nsubj")).andNot(NodePattern.N.withHead("ccomp", Semantics.directSpeech).and(CommonPatterns.insideQuotes)).noDependents("punct", CommonPatterns.HYPHEN_NODE.and(CommonPatterns.firstPhrase)).message("Several dependents of the same type"), CommonPatterns.severalDependents("xcomp").noDependents("xcomp", EnglishTreePatterns.possibleDoubleXComp).message("Several of xcomp"), CommonPatterns.severalDependents("obj").noLemma("give").andNot(EnglishTreePatterns.letS).noDependents("obj", NodePattern.or(EnglishTreePatterns.aBit, aBut, postIt, NodePattern.N.pos("NN[PS]").directlyBefore(NodePattern.N.withHeadRelation("obj")), Questions.whWord, NodePattern.N.withDependent("amod", WordConfusion.loseLoose), NodePattern.N.pos("CD"), CommonPatterns.parenthesizedPhrase.pos("NNP"))).andOptionally(NodePattern.N.withHead(NodePattern.N)).message("Several of obj"), CommonPatterns.severalDependents("acl:relcl").message("Several of acl:relcl"), CommonPatterns.conjBeforeHead.and(CommonPatterns.touchHierarchy).message("conj before head"), CommonPatterns.comma.afterHead().withHead("punct", NodePattern.N).withNextSibling(NodePattern.N.withHeadRelation("obj")).message("comma obj"), NodePattern.N.form("of").withHead("mark", NodePattern.not(NodePattern.N.withHeadRelation("acl"))).message("of <mark"), NodePattern.N.form("then").beforeHead().markAs("Then").withHead("advmod", NodePattern.N.pos("VB").withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.before("Then"))).message("Tom answers then says"), NodePattern.N.pos("VBG").markAs("VBG").noDependents("amod").withHead("amod|compound", NodePattern.N.pos("NNS").noForm("data|fees").noDependents("nummod|det|amod", NodePattern.N.before("VBG"))).message("VBing NN"), NodePattern.N.withHead("advcl|nmod|expl", NodePattern.N.withHeadRelation("amod")).andOptionally(NodePattern.N.withPrevSibling(NodePattern.N.afterHead())).andOptionally(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?")).message("advcl|nmod|expl on amod"), NodePattern.N.withHead("advmod", NodePattern.N).beforeHead().noPos("RB.*").markAs("NotAdverb").directlyBefore(NodePattern.N.withHead("case", NodePattern.N.withHead("obl", NodePattern.N.alreadyMarkedAs("NotAdverb")))).message("Advcl/advmod confusion"), NodePattern.N.withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.pos("NN.*").noDependents("cop")).and(EnglishTreePatterns.possiblyImperativeVB).noDependents().message("Imperative+Subject misparsed as Subject+NounPredicate"), NodePattern.N.form("the").andOr(NodePattern.N.withHead("case", NodePattern.N.withHeadRelation("advmod")).message("the case on advmod"), NodePattern.N.withHead("nsubj", NodePattern.N.pos("VBN").withDependent("obj")).message("the VBN obj misparsed as nsubj"), NodePattern.N.withHeadRelation("nmod").withDependent("acl", NodePattern.N.pos("VBN").directlyAfterHead()).message("misparsed the+VBN")), NodePattern.N.pos("PRP").directlyBefore(NodePattern.N.pos("MD")).withHeadRelation("nsubj").and(CommonPatterns.lastChildPhrase).message("Jenkins, who has yet to prove he can open a film"), NodePattern.N.withHeadRelation("flat").withDependent("nmod").message("nmod on flat"), NodePattern.N.withHead("compound", NodePattern.N.pos("N.*")).withDependent("obl", NodePattern.N.pos("IN").andNot(NodePattern.N.withNextSibling(NodePattern.N))).message("misattached of on compound"), NodePattern.N.inFormSequence(1, "does|do|did", EnglishTreePatterns.contractedNot.getFormRegex()).and(CommonPatterns.firstChildPhrase).noSpaceBefore().withHead("advmod", NodePattern.N.withHeadRelation("obj")).message("torn doesn't"), NodePattern.N.inFormSequence(0, "double", "the", "number").directlyAfterHead().withHead("ccomp", NodePattern.N.lemma("have")).message("double the number NP"), NodePattern.N.lemma("think").withDependent("obj", NodePattern.N.afterHead().pos("NN.*")).message("think NN"), NodePattern.ROOT.and(EnglishTreePatterns.clause).withDependent("mark", NodePattern.N.form("because")).withDependent("conj", NodePattern.N).message("because X and Y doesn't mean ..."), NodePattern.N.form("as").withHead("advmod", NodePattern.N.withHead("advmod", NodePattern.N).noDependents("advcl")).message("as <advmod <advmod"), NodePattern.N.noPos().noForm("r").withHeadRelation("cop").message("unknown cop"), NodePattern.N.form("[a-z0-9].*").directlyAfter(NodePattern.N.pos("NN.*").withHead(NodePattern.N.markAs("Head"))).directlyBefore(NodePattern.N.withHead(NodePattern.N.alreadyMarkedAs("Head")).and(n -> n.form().equals(n.neighbor(-2).form()))).message("misparsed X by X"), NodePattern.N.form("aged").pos("VBD").directlyBefore(NodePattern.N.pos("CD")).message("Past tense verb instead of participle"), NodePattern.N.form("\\$").noSpaceAfter().directlyBefore(CommonPatterns.letterWord).message("Word after $ is a placeholder"), NodePattern.N.inFormSequence(0, "cross", "-", ".*").withHeadRelation("compound").noSpaceAfter().message("a prefix parsed as compound"), NodePattern.N.inFormSequence(0, "assists?", "king").noHeadRelation("compound").message("assists king")};
    static final CrazyParseDetector INSTANCE = new CrazyParseDetector(Language.ENGLISH, crazyParse);

    EnglishCrazyParseDetector() {
    }
}

