/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogBuilder;
import org.apache.logging.log4j.message.LoggerNameAwareMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.slf4j.SLF4JLogBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JLogger
extends AbstractLogger {
    private static final long serialVersionUID = 1L;
    private static final boolean LAZY_LEVEL_CHECK = "ch.qos.logback.classic.LoggerContext".equals(LoggerFactory.getILoggerFactory().getClass().getName());
    private static final ThreadLocal<SLF4JLogBuilder> logBuilder = ThreadLocal.withInitial(SLF4JLogBuilder::new);
    private final Logger logger;
    private final LocationAwareLogger locationAwareLogger;

    public SLF4JLogger(String name, MessageFactory messageFactory, Logger logger) {
        super(name, messageFactory);
        this.logger = logger;
        this.locationAwareLogger = logger instanceof LocationAwareLogger ? (LocationAwareLogger)logger : null;
    }

    public SLF4JLogger(String name, Logger logger) {
        super(name);
        this.logger = logger;
        this.locationAwareLogger = logger instanceof LocationAwareLogger ? (LocationAwareLogger)logger : null;
    }

    private int convertLevel(Level level) {
        switch (level.getStandardLevel()) {
            case DEBUG: {
                return 10;
            }
            case TRACE: {
                return 0;
            }
            case INFO: {
                return 20;
            }
            case WARN: {
                return 30;
            }
            case ERROR: {
                return 40;
            }
        }
        return 40;
    }

    @Override
    public Level getLevel() {
        if (this.logger.isTraceEnabled()) {
            return Level.TRACE;
        }
        if (this.logger.isDebugEnabled()) {
            return Level.DEBUG;
        }
        if (this.logger.isInfoEnabled()) {
            return Level.INFO;
        }
        if (this.logger.isWarnEnabled()) {
            return Level.WARN;
        }
        if (this.logger.isErrorEnabled()) {
            return Level.ERROR;
        }
        return Level.OFF;
    }

    public Logger getLogger() {
        return this.locationAwareLogger != null ? this.locationAwareLogger : this.logger;
    }

    private static Marker getMarker(org.apache.logging.log4j.Marker marker) {
        return marker == null ? null : SLF4JLogger.convertMarker(marker);
    }

    private static Marker convertMarker(org.apache.logging.log4j.Marker marker) {
        Marker slf4jMarker = MarkerFactory.getMarker((String)marker.getName());
        org.apache.logging.log4j.Marker[] parents = marker.getParents();
        if (parents != null) {
            for (org.apache.logging.log4j.Marker parent : parents) {
                Marker slf4jParent = SLF4JLogger.getMarker(parent);
                if (slf4jMarker.contains(slf4jParent)) continue;
                slf4jMarker.add(slf4jParent);
            }
        }
        return slf4jMarker;
    }

    @Override
    public boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, Message data, Throwable t) {
        return this.isEnabledFor(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, CharSequence data, Throwable t) {
        return this.isEnabledFor(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, Object data, Throwable t) {
        return this.isEnabledFor(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, String data) {
        return this.isEnabledFor(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, String data, Object ... p1) {
        return this.isEnabledFor(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, String message, Object p0) {
        return this.isEnabledFor(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, String message, Object p0, Object p1) {
        return this.isEnabledFor(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, String message, Object p0, Object p1, Object p2) {
        return this.isEnabledFor(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        return this.isEnabledFor(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.isEnabledFor(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.isEnabledFor(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.isEnabledFor(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.isEnabledFor(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.isEnabledFor(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.isEnabledFor(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, org.apache.logging.log4j.Marker marker, String data, Throwable t) {
        return this.isEnabledFor(level, marker);
    }

    private boolean isEnabledFor(Level level, org.apache.logging.log4j.Marker marker) {
        Marker slf4jMarker = SLF4JLogger.getMarker(marker);
        switch (level.getStandardLevel()) {
            case DEBUG: {
                return this.logger.isDebugEnabled(slf4jMarker);
            }
            case TRACE: {
                return this.logger.isTraceEnabled(slf4jMarker);
            }
            case INFO: {
                return this.logger.isInfoEnabled(slf4jMarker);
            }
            case WARN: {
                return this.logger.isWarnEnabled(slf4jMarker);
            }
            case ERROR: {
                return this.logger.isErrorEnabled(slf4jMarker);
            }
        }
        return this.logger.isErrorEnabled(slf4jMarker);
    }

    @Override
    public void logMessage(String fqcn, Level level, org.apache.logging.log4j.Marker marker, Message message, Throwable t) {
        Marker slf4jMarker = SLF4JLogger.getMarker(marker);
        String formattedMessage = message.getFormattedMessage();
        if (this.locationAwareLogger != null) {
            if (message instanceof LoggerNameAwareMessage) {
                ((LoggerNameAwareMessage)((Object)message)).setLoggerName(this.getName());
            }
            this.locationAwareLogger.log(slf4jMarker, fqcn, this.convertLevel(level), formattedMessage, null, t);
        } else {
            switch (level.getStandardLevel()) {
                case DEBUG: {
                    this.logger.debug(slf4jMarker, formattedMessage, t);
                    break;
                }
                case TRACE: {
                    this.logger.trace(slf4jMarker, formattedMessage, t);
                    break;
                }
                case INFO: {
                    this.logger.info(slf4jMarker, formattedMessage, t);
                    break;
                }
                case WARN: {
                    this.logger.warn(slf4jMarker, formattedMessage, t);
                    break;
                }
                case ERROR: {
                    this.logger.error(slf4jMarker, formattedMessage, t);
                    break;
                }
                default: {
                    this.logger.error(slf4jMarker, formattedMessage, t);
                }
            }
        }
    }

    @Override
    public LogBuilder always() {
        return this.atLevel(Level.OFF);
    }

    @Override
    public LogBuilder atTrace() {
        return this.atLevel(Level.TRACE);
    }

    @Override
    public LogBuilder atDebug() {
        return this.atLevel(Level.DEBUG);
    }

    @Override
    public LogBuilder atInfo() {
        return this.atLevel(Level.INFO);
    }

    @Override
    public LogBuilder atWarn() {
        return this.atLevel(Level.WARN);
    }

    @Override
    public LogBuilder atError() {
        return this.atLevel(Level.ERROR);
    }

    @Override
    public LogBuilder atFatal() {
        return this.atLevel(Level.TRACE);
    }

    @Override
    protected LogBuilder getLogBuilder(Level level) {
        SLF4JLogBuilder builder = logBuilder.get();
        return Constants.ENABLE_THREADLOCALS && !builder.isInUse() ? builder.reset(this, level) : new SLF4JLogBuilder(this, level);
    }

    @Override
    public LogBuilder atLevel(Level level) {
        if (LAZY_LEVEL_CHECK) {
            return this.getLogBuilder(level);
        }
        return super.atLevel(level);
    }
}

