/*COPYRIGHT**
 *
 * Copyright (C) 2019 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.















**COPYRIGHT*/





#ifndef _PMU_INFO_STRUCT_H_INC_
#define _PMU_INFO_STRUCT_H_INC_

// Data Structures for storing entire PMU list
typedef struct PMU_MSR_INFO_NODE_S PMU_MSR_INFO_NODE;
struct PMU_MSR_INFO_NODE_S {
	U64 msr_id;
	U64 mask;
	U16 range;
	U16 dynamic;
	U16 msr_num_units;
	U16 num_unit_mask;
	U16 unit_multiplier;
	U16 unit_length;
};

typedef struct PMU_PCI_INFO_NODE_S PMU_PCI_INFO_NODE;
struct PMU_PCI_INFO_NODE_S {
	union {
		struct {
			U64 bus : 8;
			U64 dev : 5;
			U64 func : 3;
			U64 offset : 16;
			U64 rsvd : 32;
		} s;
		U64 reg;
	} u;
};

typedef struct PMU_PCI_UNIT_INFO_NODE_S PMU_PCI_UNIT_INFO_NODE;
struct PMU_PCI_UNIT_INFO_NODE_S {
	U32  dev;
	U32  func;
	U16 *reg_offset_list;
};

typedef struct PMU_MMIO_BAR_INFO_NODE_S PMU_MMIO_BAR_INFO_NODE;
struct PMU_MMIO_BAR_INFO_NODE_S {
	union {
		struct {
			U32 bus : 8;
			U32 dev : 5;
			U32 func : 3;
			U32 offset : 16;
		} s;
		U32 reg;
	} u;
	U8  shift;
	U8  bar_prog_type;
	U16 reserved;
	U64 mask;
};

enum { MMIO_SINGLE_BAR_TYPE = 1, MMIO_DUAL_BAR_TYPE, MMIO_DIRECT_BAR_TYPE };

typedef struct PMU_MMIO_UNIT_INFO_NODE_S PMU_MMIO_UNIT_INFO_NODE;
struct PMU_MMIO_UNIT_INFO_NODE_S {
	PMU_MMIO_BAR_INFO_NODE primary;
	PMU_MMIO_BAR_INFO_NODE secondary;
	U32                   *reg_offset_list;
};

typedef struct PMU_INFO_NODE_S PMU_INFO_NODE;
struct PMU_INFO_NODE_S {
	U16                      family;
	U16                      model;
	U16                      stepping_from;
	U16                      stepping_to;
	PMU_MSR_INFO_NODE      **msr_info_list;
	PMU_PCI_UNIT_INFO_NODE  *pci_info_list;
	PMU_MMIO_UNIT_INFO_NODE *mmio_info_list;
};

// Data Structure for search operation
typedef struct PMU_SEARCH_NODE_S PMU_SEARCH_NODE;
struct PMU_SEARCH_NODE_S {
	U64              key;  // common for MSR/PCI/MMIO
	void            *addr; // copy address of static node
	PMU_SEARCH_NODE *left;
	PMU_SEARCH_NODE *right;
	U16              height; // For balancing the search tree
	U16              range;  // For MSR
};

#endif

