/*
 * Copyright (C) 2005 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/

#ifndef _ECB_ITERATORS_H_
#define _ECB_ITERATORS_H_

#if defined(__cplusplus)
extern "C" {
#endif

//
// Loop macros to walk through the event control block
// Use for access only in the kernel mode
// To Do - Control access from kernel mode by a macro
//
#define FOR_EACH_CCCR_REG(pecb,idx) {                                                  \
    U32        (idx);                                                                  \
    U32        this_cpu__ = CONTROL_THIS_CPU();                                        \
    CPU_STATE  pcpu__  = &pcb[this_cpu__];                                             \
    U32        (dev_idx) = core_to_dev_map[this_cpu__];                                \
    U32        (cur_grp) = CPU_STATE_current_group(pcpu__);                            \
    ECB        (pecb) = LWPMU_DEVICE_PMU_register_data(&devices[dev_idx])[cur_grp];    \
    if ((pecb)) {                                                                      \
        for ((idx) = ECB_cccr_start((pecb));                                           \
             (idx) < ECB_cccr_start((pecb))+ECB_cccr_pop((pecb));                      \
             (idx)++) {                                                                \
            if (ECB_entries_reg_id((pecb),(idx)) == 0) {                               \
                continue;                                                              \
            }

#define END_FOR_EACH_CCCR_REG  }}}

#define FOR_EACH_CCCR_GP_REG(pecb,idx) {                                               \
    U32        (idx);                                                                  \
    U32        this_cpu__ = CONTROL_THIS_CPU();                                        \
    CPU_STATE  pcpu__  = &pcb[this_cpu__];                                             \
    U32        (dev_idx) = core_to_dev_map[this_cpu__];                                \
    U32        (cur_grp) = CPU_STATE_current_group(pcpu__);                            \
    ECB        (pecb) = LWPMU_DEVICE_PMU_register_data(&devices[dev_idx])[cur_grp];    \
    if ((pecb)) {                                                                      \
        for ((idx) = ECB_cccr_start((pecb));                                           \
             (idx) < ECB_cccr_start((pecb))+ECB_cccr_pop((pecb));                      \
             (idx)++) {                                                                \
            if (ECB_entries_is_gp_reg_get((pecb),(idx)) == 0) {                        \
                continue;                                                              \
            }

#define END_FOR_EACH_CCCR_GP_REG  }}}

#define FOR_EACH_ESCR_REG(pecb,idx) {                                                  \
    U32        (idx);                                                                  \
    U32        this_cpu__ = CONTROL_THIS_CPU();                                        \
    CPU_STATE  pcpu__  = &pcb[this_cpu__];                                             \
    U32        (dev_idx) = core_to_dev_map[this_cpu__];                                \
    U32        (cur_grp) = CPU_STATE_current_group(pcpu__);                            \
    ECB        (pecb) = LWPMU_DEVICE_PMU_register_data(&devices[dev_idx])[cur_grp];    \
    if ((pecb)) {                                                                      \
        for ((idx) = ECB_escr_start((pecb));                                           \
             (idx) < ECB_escr_start((pecb))+ECB_escr_pop((pecb));                      \
             (idx)++) {                                                                \
            if (ECB_entries_reg_id((pecb),(idx)) == 0) {                               \
                continue;                                                              \
            }

#define END_FOR_EACH_ESCR_REG  }}}

#define FOR_EACH_DATA_REG(pecb,idx) {                                                  \
    U32        (idx);                                                                  \
    U32        this_cpu__ = CONTROL_THIS_CPU();                                        \
    CPU_STATE  pcpu__  = &pcb[this_cpu__];                                             \
    U32        (dev_idx) = core_to_dev_map[this_cpu__];                                \
    U32        (cur_grp) = CPU_STATE_current_group(pcpu__);                            \
    ECB        (pecb) = LWPMU_DEVICE_PMU_register_data(&devices[dev_idx])[cur_grp];    \
    if ((pecb)) {                                                                      \
        for ((idx) = ECB_data_start((pecb));                                           \
             (idx) < ECB_data_start((pecb))+ECB_data_pop((pecb));                      \
             (idx)++) {                                                                \
            if (ECB_entries_reg_id((pecb),(idx)) == 0) {                               \
                continue;                                                              \
            }

#define END_FOR_EACH_DATA_REG  }}}

#define FOR_EACH_DATA_REG_UNC(pecb,device_idx,idx) {                                      \
    U32        (idx);                                                                     \
    U32        (cpu)     = CONTROL_THIS_CPU();                                            \
    U32        (pkg)     = core_to_package_map[cpu];                                      \
    U32        (cur_grp) = LWPMU_DEVICE_cur_group(&devices[(device_idx)])[(pkg)];         \
    ECB        (pecb) = LWPMU_DEVICE_PMU_register_data(&devices[(device_idx)])[cur_grp];  \
    if ((pecb)) {                                                                         \
      for ((idx) = ECB_data_start((pecb));                                                \
           (idx) < ECB_data_start((pecb))+ECB_data_pop((pecb));                           \
           (idx)++) {                                                                     \
          if (ECB_entries_reg_id((pecb),(idx)) == 0) {                                    \
              continue;                                                                   \
    }

#define END_FOR_EACH_DATA_REG_UNC  }}}

#define FOR_EACH_DATA_GP_REG(pecb,idx) {                                               \
    U32        (idx);                                                                  \
    U32        this_cpu__ = CONTROL_THIS_CPU();                                        \
    CPU_STATE  pcpu__  = &pcb[this_cpu__];                                             \
    U32        (dev_idx) = core_to_dev_map[this_cpu__];                                \
    U32        (cur_grp) = CPU_STATE_current_group(pcpu__);                            \
    ECB        (pecb) = LWPMU_DEVICE_PMU_register_data(&devices[dev_idx])[cur_grp];    \
    if ((pecb)) {                                                                      \
        for ((idx) = ECB_data_start((pecb));                                           \
             (idx) < ECB_data_start((pecb))+ECB_data_pop((pecb));                      \
             (idx)++) {                                                                \
            if (ECB_entries_is_gp_reg_get((pecb),(idx)) == 0) {                        \
                continue;                                                              \
            }

#define END_FOR_EACH_DATA_GP_REG  }}}

#define FOR_EACH_DATA_GENERIC_REG(pecb,idx) {                                          \
    U32        (idx);                                                                  \
    U32        this_cpu__ = CONTROL_THIS_CPU();                                        \
    CPU_STATE  pcpu__  = &pcb[this_cpu__];                                             \
    U32        (dev_idx) = core_to_dev_map[this_cpu__];                                \
    U32        (cur_grp) = CPU_STATE_current_group(pcpu__);                            \
    ECB        (pecb) = LWPMU_DEVICE_PMU_register_data(&devices[dev_idx])[cur_grp];    \
    if ((pecb)) {                                                                      \
        for ((idx) = ECB_data_start((pecb));                                           \
             (idx) < ECB_data_start((pecb))+ECB_data_pop((pecb));                      \
             (idx)++) {                                                                \
            if (ECB_entries_is_generic_reg_get((pecb),(idx)) == 0) {                   \
                continue;                                                              \
            }

#define END_FOR_EACH_DATA_GENERIC_REG  }}}

#define FOR_EACH_REG_ENTRY(pecb,idx) {                                                 \
    U32        (idx);                                                                  \
    U32        this_cpu__ = CONTROL_THIS_CPU();                                        \
    CPU_STATE  pcpu__  = &pcb[this_cpu__];                                             \
    U32        (dev_idx) = core_to_dev_map[this_cpu__];                                \
    U32        (cur_grp) = CPU_STATE_current_group(pcpu__);                            \
    ECB        (pecb) = LWPMU_DEVICE_PMU_register_data(&devices[dev_idx])[cur_grp];    \
    if ((pecb)) {                                                                      \
    for ((idx) = 0; (idx) < ECB_num_entries((pecb)); (idx)++) {                        \
        if (ECB_entries_reg_id((pecb),(idx)) == 0) {                                   \
            continue;                                                                  \
        }

#define END_FOR_EACH_REG_ENTRY  }}}

#define FOR_EACH_REG_ENTRY_IN_FIRST_NONNULL_GRP(pecb,idx) {                            \
    U32              (idx), j;                                                         \
    U32              this_cpu = CONTROL_THIS_CPU();                                    \
    ECB              (pecb) = NULL;                                                    \
    U32              dev_idx = core_to_dev_map[this_cpu];                              \
    for (j = 0; (S32)j < LWPMU_DEVICE_em_groups_count(&devices[dev_idx]); j++) {       \
        (pecb)     = LWPMU_DEVICE_PMU_register_data(&devices[dev_idx])[j];             \
        if (!(pecb)) {                                                                 \
            continue;                                                                  \
        }                                                                              \
        else {                                                                         \
            break;                                                                     \
        }                                                                              \
    }                                                                                  \
    if ((pecb)) {                                                                      \
        for ((idx) = 0; (idx) < ECB_num_entries((pecb)); (idx)++) {                    \
            if (ECB_entries_reg_id((pecb),(idx)) == 0) {                               \
                continue;                                                              \
            }

#define END_FOR_EACH_REG_ENTRY_IN_FIRST_NONNULL_GRP  }}}

#define FOR_EACH_REG_ENTRY_IN_ALL_GRPS(pecb,idx) {                                     \
    U32              (idx), j;                                                         \
    U32              this_cpu = CONTROL_THIS_CPU();                                    \
    ECB              (pecb) = NULL;                                                    \
    U32              dev_idx = core_to_dev_map[this_cpu];                              \
    for (j = 0; (S32)j < LWPMU_DEVICE_em_groups_count(&devices[dev_idx]); j++) {       \
        (pecb)     = LWPMU_DEVICE_PMU_register_data(&devices[dev_idx])[j];             \
        if ((pecb)) {                                                                  \
            for ((idx) = 0; (idx) < ECB_num_entries((pecb)); (idx)++) {                \
                if (ECB_entries_reg_id((pecb),(idx)) == 0) {                           \
                    continue;                                                          \
                }

#define END_FOR_EACH_REG_ENTRY_IN_ALL_GRPS  }}}}

#define FOR_EACH_REG_ENTRY_UNC(pecb,device_idx,idx) {                                          \
    U32        (idx);                                                                          \
    U32        (cpu)     = CONTROL_THIS_CPU();                                                 \
    U32        (pkg)     = core_to_package_map[cpu];                                           \
    U32        (cur_grp) = LWPMU_DEVICE_cur_group(&devices[(device_idx)])[(pkg)];              \
    ECB        (pecb)    = LWPMU_DEVICE_PMU_register_data(&devices[(device_idx)])[(cur_grp)];  \
    if ((pecb)) {                                                                              \
        for ((idx) = 0; (idx) < ECB_num_entries((pecb)); (idx)++) {                            \
            if (ECB_entries_reg_id((pecb),(idx)) == 0) {                                       \
                continue;                                                                      \
            }

#define END_FOR_EACH_REG_ENTRY_UNC  }}}

#define FOR_EACH_PCI_DATA_REG(pecb,i, device_idx, offset_delta) {                                       \
    U32                 (i)       = 0;                                                                  \
    U32                 (cpu)     = CONTROL_THIS_CPU();                                                 \
    U32                 (pkg)     = core_to_package_map[cpu];                                           \
    U32                 (cur_grp) = LWPMU_DEVICE_cur_group(&devices[(device_idx)])[(pkg)];              \
    ECB                 (pecb)    = LWPMU_DEVICE_PMU_register_data(&devices[(device_idx)])[(cur_grp)];  \
    if ((pecb)) {                                                                                       \
        for ((i) = ECB_data_start((pecb));                                                              \
             (i) < ECB_data_start((pecb))+ECB_data_pop((pecb));                                         \
             (i)++) {                                                                                   \
            if (ECB_entries_reg_offset((pecb),(i)) == 0) {                                              \
                continue;                                                                               \
            }                                                                                           \
            (offset_delta) =  ECB_entries_reg_offset((pecb),(i)) -                                      \
                              DRV_PCI_DEVICE_ENTRY_base_offset_for_mmio(&ECB_pcidev_entry_node(pecb));

#define END_FOR_EACH_PCI_DATA_REG    } } }

#define FOR_EACH_PCI_DATA_REG_RAW(pecb,i, device_idx ) {                                                \
    U32                 (i)       = 0;                                                                  \
    U32                 (cpu)     = CONTROL_THIS_CPU();                                                 \
    U32                 (pkg)     = core_to_package_map[cpu];                                           \
    U32                 (cur_grp) = LWPMU_DEVICE_cur_group(&devices[(device_idx)])[(pkg)];              \
    ECB                 (pecb)    = LWPMU_DEVICE_PMU_register_data(&devices[(device_idx)])[(cur_grp)];  \
    if ((pecb)) {                                                                                       \
        for ((i) = ECB_data_start((pecb));                                                              \
             (i) < ECB_data_start((pecb))+ECB_data_pop((pecb));                                         \
             (i)++) {                                                                                   \
            if (ECB_entries_reg_offset((pecb),(i)) == 0) {                                              \
                continue;                                                                               \
            }

#define END_FOR_EACH_PCI_DATA_REG_RAW    } } }

#define FOR_EACH_PCI_CCCR_REG_RAW(pecb,i, device_idx ) {                                            \
    U32              (i)       = 0;                                                                 \
    U32              (cpu)     = CONTROL_THIS_CPU();                                                \
    U32              (pkg)     = core_to_package_map[cpu];                                          \
    U32              (cur_grp) = LWPMU_DEVICE_cur_group(&devices[(device_idx)])[(pkg)];             \
    ECB              (pecb)    = LWPMU_DEVICE_PMU_register_data(&devices[(device_idx)])[(cur_grp)]; \
    if ((pecb)) {                                                                                   \
        for ((i) = ECB_cccr_start((pecb));                                                          \
             (i) < ECB_cccr_start((pecb))+ECB_cccr_pop((pecb));                                     \
             (i)++) {                                                                               \
            if (ECB_entries_reg_offset((pecb),(i)) == 0) {                                          \
                continue;                                                                           \
            }

#define END_FOR_EACH_PCI_CCCR_REG_RAW   } } }

#define FOR_EACH_PCI_REG_RAW(pecb, i, device_idx ) {                                                   \
    U32                 (i)       = 0;                                                                 \
    U32                 (cpu)     = CONTROL_THIS_CPU();                                                \
    U32                 (pkg)     = core_to_package_map[cpu];                                          \
    U32                 (cur_grp) = LWPMU_DEVICE_cur_group(&devices[(device_idx)])[(pkg)];             \
    ECB                 (pecb)    = LWPMU_DEVICE_PMU_register_data(&devices[(device_idx)])[(cur_grp)]; \
    if ((pecb)) {                                                                                      \
        for ((i) = 0;                                                                                  \
             (i) < ECB_num_entries((pecb));                                                            \
             (i)++) {                                                                                  \
            if (ECB_entries_reg_offset((pecb),(i)) == 0) {                                             \
                continue;                                                                              \
            }

#define END_FOR_EACH_PCI_REG_RAW   } } }

#define FOR_EACH_DATA_REG_UNC_VER2(pecb,i, device_idx ) {                                                     \
    U32            (i)    = 0;                                                                                \
    U32            (cpu)     = CONTROL_THIS_CPU();                                                            \
    U32            (pkg)     = core_to_package_map[cpu];                                                      \
    U32            (cur_grp) = LWPMU_DEVICE_cur_group(&devices[(device_idx)])[(pkg)];                         \
    ECB            (pecb) = LWPMU_DEVICE_PMU_register_data(&devices[(device_idx)])[cur_grp];                  \
    if ((pecb)) {                                                                                             \
        for ((i) = ECB_data_start((pecb));                                                                    \
             (i) < ECB_data_start((pecb))+ECB_data_pop((pecb));                                               \
             (i)++) {                                                                                         \
             if ((ECB_flags(pecb) & ECB_pci_id_offset_bit)  && (ECB_entries_reg_offset((pecb),(i)) == 0) ){   \
                  continue;                                                                                   \
             }                                                                                                \
             else if (ECB_entries_reg_id(pecb,i) == 0) {                                                      \
                 continue;                                                                                    \
             }                                                                                                \
             if (ECB_entries_emon_event_id_index_local(pecb_unc, k)) {                                        \
                 continue;                                                                                    \
             }

#define END_FOR_EACH_DATA_REG_UNC_VER2    } } }

#define CHECK_SAVE_RESTORE_EVENT_INDEX(prev_ei, cur_ei, evt_index)  {                                   \
        if (prev_ei == -1) {                                                                            \
            prev_ei = cur_ei;                                                                           \
        }                                                                                               \
        if (prev_ei < cur_ei) {                                                                         \
            prev_ei = cur_ei;                                                                           \
            evt_index++;                                                                                \
        }                                                                                               \
        else {                                                                                          \
             evt_index = 0;                                                                             \
             prev_ei = cur_ei;                                                                          \
        }}
#define FOR_EACH_REG_UNC_OPERATION(pecb, device_idx, idx, operation) {                         \
    U32        (idx);                                                                          \
    U32        (cpu)     = CONTROL_THIS_CPU();                                                 \
    U32        (pkg)     = core_to_package_map[cpu];                                           \
    U32        (cur_grp) = LWPMU_DEVICE_cur_group(&devices[(device_idx)])[(pkg)];              \
    ECB        (pecb)    = LWPMU_DEVICE_PMU_register_data(&devices[(device_idx)])[(cur_grp)];  \
    if ((pecb)) {                                                                              \
         for ((idx) = ECB_operations_register_start((pecb), (operation));                      \
              (idx) < ECB_operations_register_start((pecb), (operation)) +                     \
                      ECB_operations_register_len((pecb), (operation)); (idx)++) {             \
            if (ECB_entries_reg_id((pecb),(idx)) == 0) {                                       \
                continue;                                                                      \
            }

#define END_FOR_EACH_REG_UNC_OPERATION  }}}

#define FOR_EACH_SCHEDULED_REG_UNC_OPERATION(pecb, device_idx, idx, operation) {               \
    U32        (idx);                                                                          \
    U32        (cpu)     = CONTROL_THIS_CPU();                                                 \
    U32        (pkg)     = core_to_package_map[cpu];                                           \
    U32        (cur_grp) = LWPMU_DEVICE_cur_group(&devices[(device_idx)])[(pkg)];              \
    ECB        (pecb)    = LWPMU_DEVICE_PMU_register_data(&devices[(device_idx)])[(cur_grp)];  \
    if ((pecb)) {                                                                              \
         for ((idx) = ECB_operations_register_start((pecb), (operation));                      \
              (idx) < ECB_operations_register_start((pecb), (operation)) +                     \
                      ECB_operations_register_len((pecb), (operation)); (idx)++) {             \
            if (ECB_entries_scheduled((pecb),(idx)) != TRUE) {                                 \
                continue;                                                                      \
            }

#define END_FOR_EACH_SCHEDULED_REG_UNC_OPERATION  }}}

#define FOR_EACH_NONEVENT_REG(pecb,idx) {                                              \
    U32        (idx);                                                                  \
    U32        this_cpu__ = CONTROL_THIS_CPU();                                        \
    CPU_STATE  pcpu__  = &pcb[this_cpu__];                                             \
    U32        (dev_idx) = core_to_dev_map[this_cpu__];                                \
    U32        (cur_grp) = CPU_STATE_current_group(pcpu__);                            \
    ECB        (pecb) = LWPMU_DEVICE_PMU_register_data(&devices[dev_idx])[cur_grp];    \
    if ((pecb)) {                                                                      \
        for ((idx) = ECB_metric_start((pecb));                                         \
             (idx) < ECB_metric_start((pecb))+ECB_metric_pop((pecb));                  \
             (idx)++) {                                                                \
            if (ECB_entries_reg_id((pecb),(idx)) == 0) {                               \
                continue;                                                              \
            }

#define END_FOR_EACH_NONEVENT_REG  }}}

#if defined(__cplusplus)
}
#endif

#endif
