# Metric post-processor
Metric post-processing tool for Cloud, Data mining, and Performance Debug

<!-- TOC -->
* [Virtual Environment Recommendation](#virtual-environment-recommendation)
* [Linux](#linux)
  * [Linux Prerequisites](#linux-prerequisites)
  * [Linux Installation](#linux-installation)
  * [Linux Troubleshooting](#linux-troubleshooting)
    * [Linux Proxy Errors](#linux-proxy-errors)
* [Windows](#windows)
  * [Windows Prerequisites](#windows-prerequisites)
  * [Windows Installation](#windows-installation)
  * [Windows Troubleshooting](#windows-troubleshooting)
    * [Windows Proxy Errors](#windows-proxy-errors)
    * [Internal Python Repo (PythonSV)](#internal-python-repo--pythonsv-)
* [Running Python Metric post processor](#running-python-metric-post-processor)
* [Limitations](#limitations)
<!-- TOC -->



# Virtual Environment Recommendation

Python dependencies can be installed in the base python environment; However, a virtual environment is
recommended to prevent conflicts with other python tools and environments on the system.
The virtual environment provides a self-contained installation of all the dependencies required to run
Metric post processor ("MPP") without affecting the base system python environment. A complete list of 
python dependencies for MPP can be found in pyproject.toml in the root package directory.

# Linux

## Linux Prerequisites

1. Install python 3.7 (or later), python-dev, pip, virtualenv, and dos2unix<br>
   For Example (Ubuntu):
    ```
    sudo -E apt-get update; sudo -E apt-get upgrade
    sudo -E apt-get install python3
    sudo -E apt-get install python3-pip
    sudo -E apt-get install python3-dev (Required for system summary percentile support only)
    sudo -E apt-get install virtualenv
    ```

## Linux Installation

1. Create a virtual environment
   ```
   python3 -m venv .venv
   ```
2. Activate the virtual environment
   ```
   source .venv/bin/activate
   ```
3. Install dependencies in virtual environment with one of the following options. Note: Starting with release 5.5, requirements that depend on the C++ compiler are optional.
   ```
   # C++ compiler not required
   # System summary percentile (--percentile) NOT supported
   python -m pip install .
   ```
   ```
   # C++ compiler required (see python3-dev prerequisite)
   # Adds system summary percentile (--percentile) support to an existing installation
   python -m pip install .[percentile]
   ```
4. Verify MPP runs correctly
   ```
   python3 ./mpp.py --help
   ```
5. Deactivate the virtual environment when finished using the tool
   ```
   deactivate
   ```

## Linux Troubleshooting

### Linux Proxy Errors

If you see: WARNING: Retrying (Retry(total=4, connect=None, read=None, redirect=None, status=None)) 
after connection broken by 'ConnectTimeoutError(<pip._vendor.urllib3.connection.HTTPSConnection object at 
0x000001101FB6F430>, 'Connection to pypi.org timed out. (connect timeout=15)')': /simple/numpy/

1. Set the proxy variables.
    ```
    export HTTP_PROXY=http://<http-proxy.address>:<port>
    export HTTPS_PROXY=http://<https-proxy.address>:<port>
    export http_proxy=$HTTP_PROXY
    export https_proxy=$HTTPS_PROXY
   
2. 1. Check environment variables to ensure http_proxy and https_proxy are set
   ```
   env
   ```

# Windows

## Windows Prerequisites

1. Install python 3.7 (or later), pip, virtualenv, and dos2unix<br>

2. Required for system summary percentile support only: If Visual C++ 14.0 or greater is not installed on the system, install Visual Studio Build Tools. This does not require the purchase of a license. This is a requirement for building the 'accumulation_tree:accumulation_tree' extension required by the accumulation-tree python package (used by tdigest)

## Windows Installation

1. Install the virtualenv package
   ```
   python -m pip install virtualenv
   ```
2. Create a virtual environment
   ```
   python -m venv .venv
   ```
2. Activate the virtual environment
   ```
   .venv\scripts\activate
   ```
3. Install dependencies in virtual environment with one of the following options. Note: Starting with release 5.5, requirements that depend on the C++ compiler are optional.
   ```
   # C++ compiler not required
   # System summary percentile (--percentile) NOT supported
   python -m pip install .
   ```
   ```
   # Visual C++ compiler required (see prerequisites)
   # Adds system summary percentile (--percentile) support to an existing installation
   python -m pip install .[percentile]
   ```
4. Verify MPP runs correctly
   ```
   python mpp.py --help
   ```
5. Deactivate the virtual environment when finished using the tool
   ```
   deactivate
   ```

## Windows Troubleshooting

### Windows Proxy Errors

If you see: WARNING: Retrying (Retry(total=4, connect=None, read=None, redirect=None, status=None)) 
after connection broken by 'ConnectTimeoutError(<pip._vendor.urllib3.connection.HTTPSConnection object at 
0x000001101FB6F430>, 'Connection to pypi.org timed out. (connect timeout=15)')': /simple/numpy/

1. Set the proxy variables.
    ```
    set HTTP_PROXY=http://<http-proxy.address>:<port>
    set HTTPS_PROXY=http://<https-proxy.address>:<port>
    ```

2. Check environment variables to ensure http_proxy and https_proxy are set
   ```
   set
   ```

### Internal Python Repo (PythonSV)

Systems set up to use an internal python repository rather than the default public repository may not
have access to all the dependencies. If you see the message
"Looking in indexes: https://<index>", set the python environment to look
in the external repository instead.

   ```
   set PIP_INDEX_URL= https://pypi.python.org/simple
   python -m pip install --index-url https://pypi.python.org/simple cython
   python -m pip install --index-url https://pypi.python.org/simple .
   ```

# Running Python Metric post processor

To get usage information:

```
python mpp.py --help
```

Basic usage - generate only the System views (summary and details):

```
python mpp.py -i /path/to/emon.dat -m /path/to/metrics.xml -o /path/to/excel/output/summary.xlsx
```

Generate System and Socket views (summary and details):

```
python mpp.py -i /path/to/emon.dat -m /path/to/metrics.xml -o /path/to/excel/output/summary.xlsx --socket-view
```

Generate Uncore Unit views (summary and details):

```
python mpp.py -i /path/to/emon.dat -m /path/to/metrics.xml -o /path/to/excel/output/summary.xlsx --uncore-view
```

Generate all summary views _without_ the detail views (speeds-up processing by 10X or more):

```
python mpp.py -i /path/to/emon.dat -m /path/to/metrics.xml -o /path/to/excel/output/summary.xlsx --socket-view --core-view --thread-view --no-detail-views
```

Generate all CSVs _without_ the Excel file output (speeds-up processing by 2X or more):

```
python mpp.py -i /path/to/emon.dat -m /path/to/metrics.xml -o /path/to/file/output
```

Generate 95th percentile statistics in the system summary report (significantly slows down processing for large input files).

```
python mpp.py -i /path/to/emon.dat -m /path/to/metrics.xml -o /path/to/file/output --percentile
```

# Limitations

1. To conserve memory, we're using streaming algorithms to approximate the "95th percentile" and "variation" values
   in the System Summary view. According to our testing, the value of the 95th percentile skews toward the maximum in some cases, but does not
   fall below the exact 95th percentile.

For additional information about new features, fixed issues, and known issues, see the Release Notes.


-------------------------------------------------------------------------------
Intel and the Intel logo are trademarks of Intel Corporation in the U.S. and/or
other countries.

(*) Other names and brands may be claimed as the property of others.
Microsoft, Windows, and the Windows logo are trademarks, or registered 
trademarks of Microsoft Corporation in the United States and/or other countries.

Copyright 2023 Intel Corporation

This software and the related documents are Intel copyrighted materials, and
your use of them is governed by the express license under which they were
provided to you (License). Unless the License provides otherwise, you may not
use, modify, copy, publish, distribute, disclose or transmit this software or
the related documents without Intel's prior written permission.

This software and the related documents are provided as is, with no express or
implied warranties, other than those that are expressly stated in the License.
-------------------------------------------------------------------------------
