<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="msxsl"
                xmlns:exsl="http://exslt.org/common"
                xmlns:int="http://www.w3.org/2001/XMLSchema#int"
                xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean"
                xmlns:str="http://exslt.org/strings"
                exsl:keep_exsl_namespace=""
                syntax="norules">
  <xsl:output indent="yes" method="xml"/>
  <xsl:param name="tCount"/>
  <xsl:param name="sCount"/>
  <xsl:param name="dssCount"/>
  <xsl:param name="euCount"/>
  <xsl:param name="isTotal"/>
  <xsl:variable name="pipelineActiveMetricsAvailable">
    <xsl:choose>
      <xsl:when test="exsl:is_value_exist('dd_uncore_event_type', 'name', 'XVE_INST_EXECUTED_ALU0_ALL_UTILIZATION')">true</xsl:when>
      <xsl:otherwise>
        <xsl:for-each select="str:split(exsl:ctx('gpuAdapterNameList', ''), ';')">
          <xsl:variable name="currentGPUInfo" select="str:split(., '|')"/>
            <xsl:variable name="currentGPUBDF" select="concat('_', str:replace(str:replace(string($currentGPUInfo[1]), '.', '_'), ':', '_'), '_')" />
          <xsl:if test="exsl:is_value_exist('dd_uncore_event_type', 'name', concat('XVE_INST_EXECUTED_ALU0_ALL_UTILIZATION', $currentGPUBDF))">true</xsl:if>
        </xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:template match="/">
    <diagram>
      <xsl:attribute name="id">DG2<xsl:value-of select="$tCount"/>x<xsl:value-of select="$sCount"/>x<xsl:value-of select="$dssCount"/>x<xsl:value-of select="$euCount"/></xsl:attribute>
      <graph>
        <node id = "gpu">
          <node id="tile">
            <node id="l3"/>
            <node id="slice">
              <node id="dss">
                <node id="threadDispatcher_BTD">
                  <node id="threadDispatcher"/>
                  <node id = "BTD"/>
                </node>
                <node id = "hdc"/>
                <node id = "sampler"/>
                <node id="euArray_RTUnit">
                  <node id = "euArray"/>
                  <node id = "RTUnit"/>
                </node>
                <node id = "slml1"/>
              </node>
            </node>
          </node>
          <node id="HBM"/>
        </node>
        <node id="pcie"/>
        <node id="uncore">
          <node id="llc"/>
        </node>
        <node id="system">
          <node id="dram"/>
        </node>
        <node id = "cpu">
          <node id="cpuCores"/>
        </node>
        <link id="threadDispatcher_BTD" from="threadDispatcher" to="BTD" direction="back"/>
        <link id="euArray_RTUnit" from="euArray" to="RTUnit" direction="forward"/>
        <link id="threadDispatcher_euArray" from="threadDispatcher" to="euArray" direction="forward"/>
        <link id="BTD_euArray" from="BTD" to="euArray" direction="back"/>
        <link id="BTD_RTUnit" from="BTD" to="RTUnit" direction="back"/>
        <link id="dss_l3" from="dss" to="l3" direction="both"/>
        <link id="euArray_slml1" from="euArray" to="slml1" direction="both"/>
        <link id="RTUnit_slml1" from="RTUnit" to="slml1" direction="both"/>
        <link id="euArray_hdc" from="euArray" to="hdc" direction="both"/>
        <link id="euArray_sampler" from="euArray" to="sampler" direction="back"/>
        <link id="l3_HBM" from="l3" to="HBM" direction="both"/>
        <link id="gpu_pcie" from="gpu" to="pcie" direction="both"/>
        <link id="pcie_llc" from="pcie" to="llc" direction="both"/>
        <link id="cpu_llc" from="cpu" to="llc" direction="both"/>
        <link id="llc_dram" from="llc" to="dram" direction="both"/>
      </graph>
      <display>
        <layout id="hierarchical" boolean:routeLinks="true" boolean:doPostprocessing="true" boolean:zoomToFit="false"/>
        <xsl:variable name="prefix">
          <xsl:choose>
            <xsl:when test="$isTotal">%Total: </xsl:when>
            <xsl:otherwise>x</xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <node id="tile" displayName="%GPUXEtile" type="multiDevice" color="#EAEAEA" textColor="#666666">
          <xsl:attribute name="count"><xsl:value-of select="$prefix"/><xsl:value-of select="$tCount"/></xsl:attribute>
        </node>
        <node id="gpu" displayName="%GPU" type="logicGroup"/>
        <node id="slice" displayName="%slice" type="multiDevice" color="#CDCDCD" textColor="#666666">
          <xsl:attribute name="count"><xsl:value-of select="$prefix"/><xsl:value-of select="$sCount"/></xsl:attribute>
        </node>
        <node id="dss" displayName="%GPUXEsS" type="multiDevice" color="white" textColor="#666666">
          <xsl:attribute name="count"><xsl:value-of select="$prefix"/><xsl:value-of select="$dssCount"/></xsl:attribute>
        </node>
        <node id="euArray_RTUnit" type="invisibleGroup" layoutDirection="vertical"/>
        <node id="threadDispatcher_BTD" type="invisibleGroup" layoutDirection="vertical" boolean:verticalScale="false"/>
        <node id="threadDispatcher" displayName="%threadDispatcher" color="#92C1F4">
          <rowSet>
            <queryRef displayName="%ThreadIssued">/GPUCSThreadIssuedCount</queryRef>
          </rowSet>
        </node>
        <node id="BTD" displayName="%BTD" color="#92C1F4"/>
        <node id="RTUnit" displayName="%RTUnit" color="#C7BFD1"/>
        <node id="euArray" displayName="%GPUXEeuArray" type="multiDevice" color="#C7BFD1">
          <xsl:attribute name="count"><xsl:value-of select="$prefix"/><xsl:value-of select="$euCount"/></xsl:attribute>
          <rowSet>
            <queryRef displayName="%Active">/GPUEUActive</queryRef>
            <queryRef displayName="%Stalled">/GPUEUStalled</queryRef>
            <queryRef displayName="%Idle">/GPUEUIdle</queryRef>
            <queryRef displayName="%ThreadOccupancy">/GPUEuThreadOccupancy</queryRef>
            <queryRef displayName="%GPUXEEuFpuActiveShort">/GPUEuFpuActive</queryRef>
            <queryRef displayName="%GPUXEEuEmActiveShort">/GPUEuEmActive</queryRef>
            <queryRef displayName="%GPUXEEuXMXActiveShort">/GPUEuSysActive</queryRef>
            <xsl:if test="$pipelineActiveMetricsAvailable = ''">
              <queryRef displayName="%GPUXEEuFpuActiveShort">/GPUEuFpuInstructions</queryRef>
              <queryRef displayName="%GPUXEEuEmActiveShort">/GPUEuEmInstructions</queryRef>
              <queryRef displayName="%GPUXEEuXMXActiveShort">/GPUEuSysInstructions</queryRef>
            </xsl:if>
          </rowSet>
        </node>
        <node id="cpuCores" displayName="%CPUCores" type="multiDevice" color="#C7BFD1"/>
        <node id="cpu" displayName="%CPU" aligning="from" type="logicGroup" color="#EAEAEA">
        </node>
        <node id="sampler" displayName="%Sampler" color="#C3D1A5">
          <rowSet>
            <queryRef displayName="%Busy">/GPUSamplerBusy</queryRef>
            <queryRef displayName="%Bottleneck">/GPUSamplerBottleneck</queryRef>
          </rowSet>
        </node>
        <node id="l1" displayName="%L1" color="#f9c499"/>
        <node id="l3" displayName="%L3" color="#f9c499">
          <rowSet>
            <queryRef displayName="%MissRatio">/GPUL3MissRatio</queryRef>
          </rowSet>
        </node>
        <node id="hdc" displayName="%HDC"/>
        <node id="slml1" displayName="%SLML1" color="#E3A471"/>
        <node id="pcie" displayName="%PCIe" color="#CDCDCD"/>
        <node id="HBM" displayName="%VRAM" color="#edcdcb"/>
        <node id="uncore" displayName="%Uncore" type="logicGroup"/>
        <node id="system" displayName="%System" type="logicGroup"/>
        <node id="dram" displayName="%DRAMDGR" color="#edcdcb"/>
        <node id="llc" displayName="%LLC" color="#f9c499">
          <rowSet>
            <queryRef displayName="%MissRate">/GPULlcMissRate</queryRef>
            <queryRef displayName="%MissRatio">/GPULlcMissRatio</queryRef>
          </rowSet>
        </node>
        <link id="threadDispatcher_euArray" type="control"/>
        <link id="BTD_euArray" from="BTD" type="control"/>
        <link id="threadDispatcher_BTD" type="control"/>
        <link id="BTD_RTUnit" from="BTD" type="control"/>
        <link id="euArray_RTUnit" type="control"/>
        <link id="euArray_slml1">
          <label location="from">
            <dataTransfer>
            <bandwidth>
              <rowSet>
                <queryRef displayName="%SLMRead">/GPUSharedLocalMemoryReadBandwidthB</queryRef>
                <queryRef displayName="%LSCRead">/GPULSCReadBandwidthB</queryRef>
              </rowSet>
            </bandwidth>
            <size>
              <rowSet>
                <queryRef displayName="%SLMRead">/GPUSharedLocalMemoryReadB</queryRef>
                <queryRef displayName="%LSCRead">/GPULSCReadB</queryRef>
              </rowSet>
            </size>
            <ratio>
              <rowSet>
                <queryRef displayName="%SLMRead">/GPUSLMReadAbsMaxRatio</queryRef>
                <queryRef displayName="%LSCRead">/GPULSCReadAbsMaxRatio</queryRef>
              </rowSet>
            </ratio>
            </dataTransfer>
          </label>
          <label location="to">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef displayName="%SLMWrite">/GPUSharedLocalMemoryWriteBandwidthB</queryRef>
                  <queryRef displayName="%LSCWrite">/GPULSCWriteBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef displayName="%SLMWrite">/GPUSharedLocalMemoryWriteB</queryRef>
                  <queryRef displayName="%LSCWrite">/GPULSCWriteB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef displayName="%SLMWrite">/GPUSLMWriteAbsMaxRatio</queryRef>
                  <queryRef displayName="%LSCWrite">/GPULSCWriteAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
        </link>
        <link id="euArray_hdc" displayName="%Buffers">
          <label location="from">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef>/GPUDataportReadBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef>/GPUDataportReadB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef>/GPUDataportReadBDWAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
          <label location="to">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef>/GPUDataportWriteBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef>/GPUDataportWriteB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef>/GPUDataportWriteBDWAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
        </link>
        <link id="dss_l3" displayName="%Buffers">
          <label location="from">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef>/GPUL3ShaderReadBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef>/GPUL3ShaderReadThroughputB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef>/GPUL3ShaderReadBDWAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
          <label location="to">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef>/GPUL3ShaderWriteBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef>/GPUL3ShaderWriteThroughputB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef>/GPUL3ShaderWriteBDWAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
          <label location="center" displayName="%Total">
          </label>
        </link>
        <link id="l3_HBM">
          <label location="from">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef>/GPUMemoryReadBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef>/GPUMemoryReadB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef>/GPUMemoryReadBDWAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
          <label location="to">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef>/GPUMemoryWriteBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef>/GPUMemoryWriteB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef>/GPUMemoryWriteBDWAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
        </link>
        <link id="gpu_pcie">
          <label location="from">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef displayName="%HostWrite">/GPUHostToGpuMemoryWriteBandwidthB</queryRef>
                  <queryRef displayName="%GPURead">/GPUSysMemReadBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef displayName="%HostWrite">/GPUHostToGpuMemoryWriteB</queryRef>
                  <queryRef displayName="%GPURead">/GPUSysMemReadB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef displayName="%HostWrite">/GPUHostToGpuMemoryWriteBDWAbsMaxRatio</queryRef>
                  <queryRef displayName="%GPURead">/GPUSysMemReadBDWAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
          <label location="to">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef displayName="%HostRead">/GPUHostToGpuMemoryReadBandwidthB</queryRef>
                  <queryRef displayName="%GPUWrite">/GPUSysMemWriteBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef displayName="%HostRead">/GPUHostToGpuMemoryReadB</queryRef>
                  <queryRef displayName="%GPUWrite">/GPUSysMemWriteB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef displayName="%HostRead">/GPUHostToGpuMemoryReadBDWAbsMaxRatio</queryRef>
                  <queryRef displayName="%GPUWrite">/GPUSysMemWriteBDWAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
        </link>
        <link id="llc_dram">
          <label location="from">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef>/GPUAverageReadBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef>/GPUDataReadB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef>/GPUReadBandwidthAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
          <label location="to">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef>/GPUAverageWriteBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef>/GPUDataWrittenB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef>/GPUWriteBandwidthAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
        </link>
      </display>
    </diagram>
  </xsl:template>
</xsl:stylesheet>
