//// (c) 1992-2024 Intel Corporation.                            
// Intel, the Intel logo, Intel, MegaCore, NIOS II, Quartus and TalkBack words    
// and logos are trademarks of Intel Corporation or its subsidiaries in the U.S.  
// and/or other countries. Other marks and brands may be claimed as the property  
// of others. See Trademarks on intel.com for full list of Intel trademarks or    
// the Trademarks & Brands Names Database (if Intel) or See www.Intel.com/legal (if Altera) 
// Your use of Intel Corporation's design tools, logic functions and other        
// software and tools, and its AMPP partner logic functions, and any output       
// files any of the foregoing (including device programming or simulation         
// files), and any associated documentation or information are expressly subject  
// to the terms and conditions of the Altera Program License Subscription         
// Agreement, Intel MegaCore Function License Agreement, or other applicable      
// license agreement, including, without limitation, that your use is for the     
// sole purpose of programming logic devices manufactured by Intel and sold by    
// Intel or its authorized distributors.  Please refer to the applicable          
// agreement for further details.                                                 


// This module serves as a wrapper for acl_channel_fifo, following the AXI
// streaming signal naming convention.

`default_nettype none

module acl_channel_fifo_axi #(
    //core spec
    parameter int FIFO_DEPTH = 16,                      //minimum depth of the fifo, note the IP will quantize depth to fully utilize the memory of MLAB or M20K
    parameter int ALMOST_FULL_VALUE = 0,                //threshold at which to assert almost full, used to predicate writes into non-blocking iowr if channel won't have space
    parameter int DATA_W = 64,                          //width of the data path

    //reset
    parameter bit ASYNC_RESET = 1,                      //should registers consume reset asynchronously (ASYNC_RESET=1) or synchronously (ASYNC_RESET=0)
    parameter bit SYNCHRONIZE_RESET = 0,                //before consumption by registers, should the reset be synchronized to the clock

    //consolidation of channel capacity
    parameter bit BYPASS_CHANNEL = 0,                   //if it is beneficial to merge the capacity of the channel fifo into either iord or iowr, then acl_channel_fifo_axi should act as wires
    parameter int INTER_KERNEL_PIPELINING = 0,          //how much pipelining to add before the single fifo that holds all of the capacity for iowr, channel and iord

    //others
    parameter bit ALLOW_HIGH_SPEED_FIFO_USAGE = 0,      //choice of hld_fifo style, 0 = mid speed fifo, 1 = high speed fifo
    parameter bit ACL_PROFILE = 0,                      //enable the profiler
    parameter     enable_ecc = "FALSE",                 //enable error correction codes for RAM, legal values are "FALSE" or "TRUE"
    parameter     INTENDED_DEVICE_FAMILY = "Arria 10"   //which FPGA family to use
) (
    input  wire                 clock,
    input  wire                 resetn,

    //write side of fifo -- beware the naming, think of "in_" as the interface name, "in" in the name does not mean input
    //all interfaces are stall/valid unless the fifo is put into bypass mode (but in that case iord and iowr talk to each other directly, so channel doesn't care if handshake is stall latency or not)
    input  wire                 in_tvalid,
    input  wire    [DATA_W-1:0] in_tdata,
    output logic                in_tready,
    output logic                almost_full,
    output logic                in_channel_stall,  //to iowr, iord tells iowr when the channel interface would have been stalling upstream, intended for profiler

    //read side of fifo
    output logic                out_tvalid,
    output logic   [DATA_W-1:0] out_tdata,
    input  wire                 out_tready,
    input  wire                 out_almost_full,   //provided by iord, goes out through almost_full, used to predicate writes into non-blocking iowr if channel won't have space (where channel is implemented in iord)
    input  wire                 out_channel_stall, //from iord, iord tells iowr when the channel interface would have been stalling upstream, intended for profiler

    //others
    output logic          [1:0] ecc_err_status,         //error correction code status
    output logic         [31:0] profile_fifosize,       //occupancy of the channel fifo
    input  wire          [31:0] in_fifosize,       //the fifosize from iowr, in case it took up the channel capacity
    input  wire          [31:0] out_fifosize       //the fifosize from iord, in case it took up the channel capacity
);
    acl_channel_fifo
    #(
        .FIFO_DEPTH                  (FIFO_DEPTH),
        .ALMOST_FULL_VALUE           (ALMOST_FULL_VALUE),
        .DATA_W                      (DATA_W),
        .ASYNC_RESET                 (ASYNC_RESET),
        .SYNCHRONIZE_RESET           (SYNCHRONIZE_RESET),
        .BYPASS_CHANNEL              (BYPASS_CHANNEL),
        .INTER_KERNEL_PIPELINING     (INTER_KERNEL_PIPELINING),
        .ALLOW_HIGH_SPEED_FIFO_USAGE (ALLOW_HIGH_SPEED_FIFO_USAGE),
        .ACL_PROFILE                 (ACL_PROFILE),
        .enable_ecc                  (enable_ecc),
        .INTENDED_DEVICE_FAMILY      (INTENDED_DEVICE_FAMILY)
    )
    acl_channel_fifo_inst
    (
        .clock                        (clock),
        .resetn                       (resetn),
        .avst_in_valid                (in_tvalid),
        .avst_in_data                 (in_tdata),
        .avst_in_ready                (in_tready),
        .almost_full                  (almost_full),
        .avst_in_channel_stall        (in_channel_stall),
        .avst_out_valid               (out_tvalid),
        .avst_out_data                (out_tdata),
        .avst_out_ready               (out_tready),
        .avst_out_almost_full         (out_almost_full),
        .avst_out_channel_stall       (out_channel_stall),
        .ecc_err_status               (ecc_err_status),
        .profile_fifosize             (profile_fifosize),
        .avst_in_fifosize             (in_fifosize),
        .avst_out_fifosize            (out_fifosize)
    );

endmodule

`default_nettype wire

