/*
 * Copyright (C) 2020 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/

#pragma OPENCL EXTENSION cl_khr_fp16 : enable

// DotH 53760000Gr:0h/53760000Gr:0h/53760000Gw:0h 13440000 0 1
__kernel void DotH(__global half *pA, __global half *pB, __global half *pC)
{
    const int id = get_global_id(0);

    half4 a = (half4)(pA[4 * id], pA[4 * id + 1], pA[4 * id + 2], pA[4 * id + 3]);
    half4 b = (half4)(pB[4 * id], pB[4 * id + 1], pB[4 * id + 2], pB[4 * id + 3]);
    //half2 a = (half2)(pA[4*id], pA[4*id+1]);
    //half2 b = (half2)(pB[4*id], pB[4*id+1]);

    pC[id] = dot(a, b);
}
