<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009-2025 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl"
xmlns:int="http://www.w3.org/2001/XMLSchema#int"
xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean"
xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong"
xmlns:str="http://exslt.org/strings"
xmlns:exsl="http://exslt.org/common"
exsl:keep_exsl_namespace="" syntax="norules">
  <xsl:output indent="yes" method="xml"/>
  <xsl:param name="errorsAsWarnings">false</xsl:param>
  <xsl:param name="isGpuHWMetricsCollectionPossible"></xsl:param>
  <xsl:param name="areGpuHardwareMetricsAvailable"></xsl:param>
  <xsl:decimal-format name="double-en" decimal-separator="." grouping-separator=""/>
  <xsl:template match="/">
    <common>
      <collector>
        <xsl:choose>
          <xsl:when test="$isGpuHWMetricsCollectionPossible = 'true'">
            <xsl:if test="$areGpuHardwareMetricsAvailable = 'RemoteDesktopWarning'">
              <xsl:value-of select="exsl:warning('knob.gpu_profiling.gpu_remote_desktop_warn')"/>
            </xsl:if>
            <xsl:if test="exsl:ctx('i915Status', 'true') = 'DriverInCustomLocation'">
              <xsl:value-of select="exsl:warning('knob.gpu_profiling.i915_in_custom_location_warn')"/>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="gpuDriverError">
              <xsl:if test="exsl:ctx('targetOS')='Linux' and $areGpuHardwareMetricsAvailable = 'UnsupportedInterfaceVersion'">
                <xsl:choose>
                  <xsl:when test="exsl:ctx('i915Status', 'true') = 'MissingDriver'">
                    %GpuMissingDriver
                  </xsl:when>
                  <xsl:when test="exsl:ctx('i915Status', 'true') = 'InsufficientPermissions'">
                    %GpuInsufficientPermissionsLinux
                  </xsl:when>
                  <xsl:when test="exsl:ctx('i915Status', 'true') = 'KernelNotPatched'">
                    %GpuKernelNotPatched
                  </xsl:when>
                </xsl:choose>
              </xsl:if>
            </xsl:variable>
            <xsl:if test="$gpuDriverError != ''">
              <xsl:choose>
                <xsl:when test="$errorsAsWarnings = 'true'">
                  <xsl:value-of select="exsl:warning($gpuDriverError)"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="exsl:error($gpuDriverError)"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:if>
            <xsl:variable name="kernelVersion" select="string(exsl:ctx('LinuxRelease', ''))"/>
            <xsl:variable name="currentKernelVersions" select="str:tokenize($kernelVersion, '.-')"/>
            <xsl:variable name="isLinuxKernel4p14OrGreater" select="(number($currentKernelVersions[1]) &gt; number(4)) or
               (number($currentKernelVersions[1]) = number(4) and (number($currentKernelVersions[2]) &gt;= number(14)))"/>
            <xsl:variable name="gpuHwMetricsError">
              <xsl:choose>
                <xsl:when test="exsl:ctx('preferedGpuAdapter', 'none') = 'none'">
                  %GpuDriverNotResponding
                </xsl:when>
                <xsl:when test="exsl:ctx('targetGPU', '') != '' and $areGpuHardwareMetricsAvailable = 'AdapterNotFound'">
                  %SelectedGpuNotFound
                </xsl:when>
                <xsl:when test="$areGpuHardwareMetricsAvailable = 'NotSelectedAdapter'">
                  %MetricsNotAvailableForSelectedGpu
                </xsl:when>
                <xsl:when test="$areGpuHardwareMetricsAvailable = 'UnsupportedMultiAdapter'">
                  %MetricsNotAvailableForSelectedGpu
                </xsl:when>
                <xsl:when test="$areGpuHardwareMetricsAvailable = 'RemoteDesktopError'">
                  %GpuRemoteDesktopError
                </xsl:when>
                <xsl:when test="$areGpuHardwareMetricsAvailable = 'DriverNotResponding'">
                  %GpuDriverNotResponding
                </xsl:when>
                <xsl:when test="$areGpuHardwareMetricsAvailable = 'UnsupportedHardware'">
                  %GpuUnsupportedHardware
                </xsl:when>
                <xsl:when test="$areGpuHardwareMetricsAvailable = 'InsufficientPermissions'">
                  <xsl:choose>
                    <xsl:when test="exsl:ctx('targetOS')='Linux'">
                      %GpuInsufficientPermissionsLinux
                    </xsl:when>
                    <xsl:otherwise>
                      %GpuInsufficientPermissions
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:when test="($areGpuHardwareMetricsAvailable = 'KernelNotPatched') and
                                not($isLinuxKernel4p14OrGreater)">
                  %GpuKernelNotPatched
                </xsl:when>
                <xsl:when test="$areGpuHardwareMetricsAvailable = 'LibNotFound'">
                  <xsl:choose>
                    <xsl:when test="exsl:ctx('targetOS')='Linux'">
                      <xsl:choose>
                        <xsl:when test="$isLinuxKernel4p14OrGreater">
                          %GpuLibNotFoundLinuxNewKernel
                        </xsl:when>
                        <xsl:otherwise>
                          %GpuLibNotFoundLinux
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:when>
                    <xsl:when test="exsl:ctx('targetOS')='Windows'">
                      %GpuLibNotFoundWindows
                    </xsl:when>
                    <xsl:otherwise>
                      %GpuLibNotFound
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:when test="$areGpuHardwareMetricsAvailable = 'LibLoadFailed'">
                  <xsl:choose>
                    <xsl:when test="exsl:ctx('targetOS')='Linux'">
                      <xsl:choose>
                        <xsl:when test="$isLinuxKernel4p14OrGreater">
                          %GpuLibLoadFailedLinuxNewKernel
                        </xsl:when>
                        <xsl:otherwise>
                          %GpuLibLoadFailedLinux
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:when>
                    <xsl:when test="exsl:ctx('targetOS')='Windows'">
                      %GpuLibLoadFailedWindows
                    </xsl:when>
                    <xsl:otherwise>
                      %GpuLibLoadFailed
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:when test="$areGpuHardwareMetricsAvailable = 'UnsupportedInterfaceVersion'">
                  <xsl:choose>
                    <xsl:when test="(exsl:ctx('targetOS')='Linux') and ($isLinuxKernel4p14OrGreater)">
                      %GpuUnsupportedInterfaceVersionLinuxNewKernel
                    </xsl:when>
                    <xsl:when test="(exsl:ctx('targetOS')='Linux') and not($isLinuxKernel4p14OrGreater)">
                      %GpuUnsupportedInterfaceVersionLinux
                    </xsl:when>
                    <xsl:when test="exsl:ctx('targetOS')='Windows'">
                      %GpuUnsupportedInterfaceVersionWindows
                    </xsl:when>
                    <xsl:otherwise>
                      %GpuUnsupportedInterfaceVersion
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:when test="$areGpuHardwareMetricsAvailable = 'InitializationError'">
                  <xsl:choose>
                    <xsl:when test="exsl:ctx('targetOS')='Linux'">
                      <xsl:choose>
                        <xsl:when test="$isLinuxKernel4p14OrGreater">
                          %GpuLibInitErrorLinuxNewKernel
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:choose>
                            <xsl:when test="contains(exsl:ctx('LinuxRelease', ''), '3.10')   or
                                            contains(exsl:ctx('LinuxRelease', ''), '3.14.5') or
                                            contains(exsl:ctx('LinuxRelease', ''), '4.4')    or
                                            contains(exsl:ctx('LinuxRelease', ''), '4.7')">
                              %GpuLibInitErrorLinux
                            </xsl:when>
                            <xsl:otherwise>
                              %GpuKernelNotSupported
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                      %GpuCountersNotSupported
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:when test="$areGpuHardwareMetricsAvailable = ''">
                    %GpuCountersAgentNotAvailable
                </xsl:when>
                <xsl:when test="$areGpuHardwareMetricsAvailable = 'false'">
                    %GpuCountersNotSupported
                </xsl:when>
              </xsl:choose>
            </xsl:variable>
            <xsl:if test="$gpuHwMetricsError != ''">
              <xsl:choose>
                <xsl:when test="$errorsAsWarnings = 'true'">
                  <xsl:value-of select="exsl:warning($gpuHwMetricsError)"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="exsl:error($gpuHwMetricsError)"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:if>
           </xsl:otherwise>
        </xsl:choose>
      </collector>
    </common>
  </xsl:template>
</xsl:stylesheet>
