/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildprocess.execution;

import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.launcher.exec.BuildActionExecutor;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.launcher.exec.BuildExecutor;

public class SetupLoggingActionExecutor
implements BuildExecutor {
    private final BuildActionExecutor<BuildActionParameters, BuildRequestContext> delegate;
    private final LoggingManagerInternal loggingManager;

    public SetupLoggingActionExecutor(LoggingManagerInternal loggingManager, BuildActionExecutor<BuildActionParameters, BuildRequestContext> delegate) {
        this.loggingManager = loggingManager;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildActionResult execute(BuildAction action, BuildActionParameters actionParameters, BuildRequestContext requestContext) {
        StartParameterInternal startParameter = action.getStartParameter();
        this.loggingManager.setLevelInternal(startParameter.getLogLevel());
        this.loggingManager.enableUserStandardOutputListeners();
        this.loggingManager.start();
        try {
            BuildActionResult buildActionResult = this.delegate.execute(action, (Object)actionParameters, (Object)requestContext);
            return buildActionResult;
        }
        finally {
            this.loggingManager.stop();
        }
    }
}

