/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.ClockBlockCacheTable;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCacheConfig;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCacheTable;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.pack.PackExt;

class PackExtBlockCacheTable
implements DfsBlockCacheTable {
    private final String name;
    private final DfsBlockCacheTable defaultBlockCacheTable;
    private final List<DfsBlockCacheTable> blockCacheTableList;
    private final Map<PackExt, DfsBlockCacheTable> extBlockCacheTables;

    static PackExtBlockCacheTable fromBlockCacheConfigs(DfsBlockCacheConfig cacheConfig) {
        ClockBlockCacheTable defaultTable = new ClockBlockCacheTable(cacheConfig);
        HashMap<PackExt, DfsBlockCacheTable> packExtBlockCacheTables = new HashMap<PackExt, DfsBlockCacheTable>();
        List<DfsBlockCacheConfig.DfsBlockCachePackExtConfig> packExtConfigs = cacheConfig.getPackExtCacheConfigurations();
        if (packExtConfigs == null || packExtConfigs.size() == 0) {
            throw new IllegalArgumentException(JGitText.get().noPackExtConfigurationGiven);
        }
        for (DfsBlockCacheConfig.DfsBlockCachePackExtConfig packExtCacheConfig : packExtConfigs) {
            ClockBlockCacheTable table = new ClockBlockCacheTable(packExtCacheConfig.getPackExtCacheConfiguration());
            for (PackExt packExt : packExtCacheConfig.getPackExts()) {
                if (packExtBlockCacheTables.containsKey((Object)packExt)) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().duplicatePackExtensionsForCacheTables, new Object[]{packExt}));
                }
                packExtBlockCacheTables.put(packExt, table);
            }
        }
        return PackExtBlockCacheTable.fromCacheTables(defaultTable, packExtBlockCacheTables);
    }

    static PackExtBlockCacheTable fromCacheTables(DfsBlockCacheTable defaultBlockCacheTable, Map<PackExt, DfsBlockCacheTable> packExtBlockCacheTables) {
        HashSet<DfsBlockCacheTable> blockCacheTables = new HashSet<DfsBlockCacheTable>();
        blockCacheTables.add(defaultBlockCacheTable);
        blockCacheTables.addAll(packExtBlockCacheTables.values());
        String name = defaultBlockCacheTable.getName() + "," + packExtBlockCacheTables.values().stream().map(DfsBlockCacheTable::getName).sorted().collect(Collectors.joining(","));
        return new PackExtBlockCacheTable(name, defaultBlockCacheTable, List.copyOf(blockCacheTables), packExtBlockCacheTables);
    }

    private PackExtBlockCacheTable(String name, DfsBlockCacheTable defaultBlockCacheTable, List<DfsBlockCacheTable> blockCacheTableList, Map<PackExt, DfsBlockCacheTable> extBlockCacheTables) {
        this.name = name;
        this.defaultBlockCacheTable = defaultBlockCacheTable;
        this.blockCacheTableList = blockCacheTableList;
        this.extBlockCacheTables = extBlockCacheTables;
    }

    @Override
    public boolean hasBlock0(DfsStreamKey key) {
        return this.getTable(key).hasBlock0(key);
    }

    @Override
    public DfsBlock getOrLoad(BlockBasedFile file, long position, DfsReader dfsReader, DfsBlockCache.ReadableChannelSupplier fileChannel) throws IOException {
        return this.getTable(file.ext).getOrLoad(file, position, dfsReader, fileChannel);
    }

    @Override
    public <T> DfsBlockCache.Ref<T> getOrLoadRef(DfsStreamKey key, long position, DfsBlockCache.RefLoader<T> loader) throws IOException {
        return this.getTable(key).getOrLoadRef(key, position, loader);
    }

    @Override
    public void put(DfsBlock v) {
        this.getTable(v.stream).put(v);
    }

    @Override
    public <T> DfsBlockCache.Ref<T> put(DfsStreamKey key, long pos, long size, T v) {
        return this.getTable(key).put(key, pos, size, v);
    }

    @Override
    public <T> DfsBlockCache.Ref<T> putRef(DfsStreamKey key, long size, T v) {
        return this.getTable(key).putRef(key, size, v);
    }

    @Override
    public boolean contains(DfsStreamKey key, long position) {
        return this.getTable(key).contains(key, position);
    }

    @Override
    public <T> T get(DfsStreamKey key, long position) {
        return this.getTable(key).get(key, position);
    }

    @Override
    public List<DfsBlockCacheTable.BlockCacheStats> getBlockCacheStats() {
        return this.blockCacheTableList.stream().flatMap(cacheTable -> cacheTable.getBlockCacheStats().stream()).collect(Collectors.toList());
    }

    @Override
    public String getName() {
        return this.name;
    }

    private DfsBlockCacheTable getTable(PackExt packExt) {
        return this.extBlockCacheTables.getOrDefault((Object)packExt, this.defaultBlockCacheTable);
    }

    private DfsBlockCacheTable getTable(DfsStreamKey key) {
        return this.extBlockCacheTables.getOrDefault((Object)PackExtBlockCacheTable.getPackExt(key), this.defaultBlockCacheTable);
    }

    private static PackExt getPackExt(DfsStreamKey key) {
        return PackExt.values()[key.packExtPos];
    }
}

