/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.terminal.TerminalOutput;
import net.rubygrapefruit.platform.terminal.Terminals;

public abstract class AbstractTerminal
implements TerminalOutput {
    protected static byte[] NEW_LINE = System.getProperty("line.separator").getBytes();

    protected abstract void init();

    protected static OutputStream streamForOutput(Terminals.Output output) {
        return output == Terminals.Output.Stdout ? new FileOutputStream(FileDescriptor.out) : new FileOutputStream(FileDescriptor.err);
    }

    @Override
    public TerminalOutput newline() throws NativeException {
        this.write(NEW_LINE);
        return this;
    }

    @Override
    public TerminalOutput write(CharSequence text) throws NativeException {
        byte[] bytes = text.toString().getBytes();
        this.write(bytes);
        return this;
    }

    @Override
    public TerminalOutput write(char ch) throws NativeException {
        this.write(Character.toString(ch));
        return this;
    }

    protected void write(byte[] bytes) {
        try {
            this.getOutputStream().write(bytes);
        }
        catch (IOException e) {
            throw new NativeException("Could not write to output stream.", e);
        }
    }
}

