---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Age secret key'
---

## Description

The response body contains content that matches the pattern of an age encryption secret key was detected. Age is a modern and secure file encryption tool, format, and Go library. It features small explicit keys, no configuration options, and UNIX-style composability. These keys are usually used for encrypting sensitive files. A malicious actor with access to this key can decrypt any file or message encrypted with it.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet). To generate a new age key, run the following command:  ```console age-keygen -o new_key.age```  Consider protecting the identity file with a passphrase. This may not be possible if this key is intended to be used in automated systems:  ```console age-keygen | age -p > new_key.age```

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.4 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
