---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: マージリクエストの内容を確認したときに自動マージを設定すると、すべてのマージチェックに合格した場合、介入なしでマージできます。
title: 自動マージ
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- **パイプラインが成功したときにマージ**と**Add to merge train when pipeline succeeds**（パイプラインが成功したときにマージトレインに追加）は、GitLab 16.0で、`auto_merge_labels_mr_widget`[フラグ](../../../administration/feature_flags/_index.md)とともに**Auto-merge**（自動マージ）に[名前が変更](https://gitlab.com/gitlab-org/gitlab/-/issues/409530)されました。デフォルトでは有効になっています。
- GitLab 16.0で自動マージ機能の名称が変更され[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120922)になりました。機能フラグ`auto_merge_labels_mr_widget`は削除されました。
- 拡張された自動マージ機能は、GitLab 16.5で、`merge_when_checks_pass`および`additional_merge_when_checks_ready`の[2つのフラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/10874)されました。デフォルトでは無効になっています。
- GitLab 17.0のGitLab.comで`merge_when_checks_pass`および`additional_merge_when_checks_ready`フラグを[有効化](https://gitlab.com/gitlab-org/gitlab/-/issues/412995)しました。
- GitLab 17.1で`additional_merge_when_checks_ready`フラグと`merge_when_checks_pass`フラグを[マージ](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154366)しました。
- マージトレインの自動マージは、GitLab 17.2で`merge_when_checks_pass_merge_train`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/10874)されました。デフォルトでは無効になっています。
- マージトレインの自動マージは、GitLab 17.2のGitLab.comで[有効化](https://gitlab.com/gitlab-org/gitlab/-/issues/470667)されました。
- GitLab 17.4のGitLab Self-Managedでフラグ`merge_when_checks_pass`をデフォルトで[有効化](https://gitlab.com/gitlab-org/gitlab/-/issues/412995)しました。
- マージトレインの自動マージは、GitLab 17.7で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174357)になりました。機能フラグ`merge_when_checks_pass_merge_train`は削除されました。
- 自動マージは、GitLab 17.7で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/412995)になりました。機能フラグ`merge_when_checks_pass`は削除されました。

{{< /history >}}

マージリクエストの内容をマージする準備ができている場合は、**自動マージに設定**を選択できます。必要なチェックがすべて正常に完了すると、マージリクエストは自動的にマージされます。したがって、マージリクエストを手動でマージすることを覚えておく必要はありません。

マージチェックを使用すると、マージリクエストの内容のレビューに集中し、プロジェクト設定を使用してマージ可能性を判断できます。マージリクエストをレビューする際に、マージリクエストの変更を承認する場合は、自動マージに設定します。GitLabはプロジェクト設定を適用し、マージリクエストがすべてのマージチェック（必須のコードオーナーや承認ルールなど）を満たすまで、マージできません。必要なマージチェックをすべて満たすと、マージリクエストがマージされます。ユーザーによる操作は不要です。

マージチェックには、合格したCI/CDパイプラインや、次のようなその他多くのものが含まれます:

- 必要な承認がすべて付与されている必要があります。
- 他のマージリクエストがこのマージリクエストをブロックしていません。
- マージコンフリクトが存在していません。
- CI/CDパイプラインが、[プロジェクト設定](#require-a-successful-pipeline-for-merge)に関係なく、正常に完了しています。
- すべてのディスカッションが解決されています。
- マージリクエストが**ドラフト**ではありません。
- すべての外部ステータスチェックに合格しています。
- マージリクエストが開いてる必要があります。
- 拒否されたポリシーが存在していません。
- プロジェクトで[マージリクエストがJiraのイシューを参照する必要がある](../../../integration/jira/issues.md#require-associated-jira-issue-for-merge-requests-to-be-merged)場合、マージリクエストのタイトルまたは説明にJiraのイシューリンクが含まれます。
- マージリクエストに**Merge after**（Merge after）の日付が設定されている場合、現在の時刻は設定された日付以降である必要があります。

チェックの完全なリストとそのAPI相当のものについては、[マージステータス](../../../api/merge_requests.md#merge-status)を参照してください。

![自動マージの準備完了](img/auto_merge_ready_v16_0.png)

自動マージを設定した後、マージリクエストのマージ時に[自動クローズ](../issues/managing_issues.md#closing-issues-automatically)するイシューを変更することはできません。

## マージリクエストを自動マージする {#auto-merge-a-merge-request}

前提要件:

- プロジェクトのデベロッパーロール以上を持っている必要があります。
- プロジェクトの設定で必要な場合、マージリクエストのすべてのスレッドを解決する必要があります。
- マージリクエストは、必要な承認をすべて受けている必要があります。

コマンドラインからプッシュするときにこれを行うには、`merge_request.merge_when_pipeline_succeeds`[プッシュオプション](../../../topics/git/commit.md#push-options)を使用します。

GitLabユーザーインターフェースからこれを行うには、以下の手順を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択します。
1. 編集するマージリクエストを選択します。
1. マージリクエストレポートセクションまでスクロールします。
1. オプション。**ソースブランチを削除**、**コミットをスカッシュ**、**コミットメッセージを編集**など、必要なマージオプションを選択します。
1. マージリクエストレポートセクションの内容を確認してください。[Issue closing pattern](../issues/managing_issues.md#closing-issues-automatically)が含まれている場合は、マージリクエストのマージ時にイシューをクローズする必要があることを確認します:

   ![このマージリクエストはイシュー#2754をクローズします。](img/closing_pattern_v18_5.png)

1. **自動マージに設定**を選択します。

自動マージに設定した後、パイプラインが完了する前にマージリクエストにコメントした場合、既存のすべてのスレッドを解決するまでマージはブロックされます。

## 自動マージをキャンセルする {#cancel-an-auto-merge}

マージリクエストの自動マージをキャンセルできます。

前提要件:

- マージリクエストの作成者であるか、デベロッパーロール以上のプロジェクトメンバーである必要があります。
- マージリクエストのパイプラインがまだ進行中である必要があります。

これを行うには、次の手順を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択します。
1. 目的のマージリクエストを選択します。
1. マージリクエストレポートセクションまでスクロールします。
1. **自動マージのキャンセル**を選択します。

![パイプライン](img/cancel-mwps_v15_4.png)成功時にマージをキャンセルする

## 自動マージのパイプラインの成功 {#pipeline-success-for-auto-merge}

パイプラインが成功すると、マージリクエストがマージされます。パイプラインが失敗した場合、作成者は失敗したジョブを再試行するか、次のように新しいコミットをプッシュして失敗を修正できます:

- 再試行されたジョブが2回目の試行で成功した場合、マージリクエストがマージされます。
- マージリクエストに新しいコミットを追加すると、GitLabはリクエストをキャンセルし、マージ前に新しい変更がレビューされるようにします。
- マージリクエストのターゲットブランチに新しいコミットを追加し、プロジェクトが高速早送りのマージリクエストのみを許可している場合、GitLabはマージコンフリクトを防ぐためにリクエストをキャンセルします。

パイプラインのステータスをより厳密に制御するために、マージ前に[パイプラインの成功を必須とする](#require-a-successful-pipeline-for-merge)こともできます。

### マージに成功したパイプラインを必須にする {#require-a-successful-pipeline-for-merge}

マージする前に、完全に成功したパイプラインを必須とするようにプロジェクトを設定できます。この設定は次の両方で機能します:

- GitLab CI/CDパイプライン。
- [外部CIインテグレーション](../integrations/_index.md#available-integrations)から実行されるパイプライン。

その結果、[GitLab CI/CDパイプラインを無効にする](../../../ci/pipelines/settings.md#disable-gitlab-cicd-pipelines)と、この機能は無効にならなくなります。しかし、外部CIプロバイダーからのパイプラインをこの機能で使用することはできます。

前提要件:

- プロジェクトのCI/CD設定が、すべてのマージリクエストに対してパイプラインを実行することを確認します。
- プロジェクトのメンテナーロール以上を持っている必要があります。

この設定を有効にするには、次の手順を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **マージリクエスト**を選択します。
1. **マージチェック**までスクロールし、**パイプラインが完了している**を選択します。この設定では、パイプラインがない場合にマージリクエストのマージも防がれます。したがって、[一部のルールと競合する](#merge-request-cant-merge-despite-no-failed-pipeline)可能性があります。
1. **保存**を選択します。

[同じマージリクエストに対して複数のパイプラインタイプが実行される](#merge-request-can-still-be-merged-despite-a-failed-pipeline)場合、マージリクエストパイプラインは他のパイプラインタイプよりも優先されます。たとえば、古いが成功したマージリクエストパイプラインでは、新しく失敗したブランチパイプラインがあるにもかかわらず、マージリクエストをマージできます。

### スキップされたパイプラインの後にマージを許可する {#allow-merge-after-skipped-pipelines}

プロジェクトに**パイプラインが完了している**を設定すると、[スキップされたパイプライン](../../../ci/pipelines/_index.md#skip-a-pipeline)によってマージリクエストがマージされなくなります。

前提要件:

- プロジェクトのメンテナーロール以上を持っている必要があります。

この動作を変更するには、次の手順を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **マージリクエスト**を選択します。
1. **マージチェック**の下で: 
   - **パイプラインが完了している**を選択します。
   - **スキップしたパイプラインは成功と見なされます**を選択します。
1. **保存**を選択します。

## 特定の日付より前のマージを禁止する {#prevent-merge-before-a-specific-date}

{{< history >}}

- GitLab 17.6で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/14380)されました。

{{< /history >}}

マージリクエストを特定の日時より前にマージすべきでない場合は、**マージ開始日時**を設定します。この値は、マージ（またはマージトレイン）をいつ開始できるかを設定します。ただし、マージの正確な時間は、他のマージチェックの満足度やマージトレインの長さに応じて異なる場合があります。

前提要件:

- プロジェクトのデベロッパーロール以上を持っている必要があります。

これを行うには、次の手順を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択します。
1. 編集するマージリクエストを選択します。
1. **編集**を選択します。
1. **マージ開始日時**ドロップダウンリストから、`After scheduled date`を選択し、日時を選択します。
1. **変更を保存**を選択します。

## トラブルシューティング {#troubleshooting}

### パイプラインが失敗していないにもかかわらず、マージリクエストをマージできない {#merge-request-cant-merge-despite-no-failed-pipeline}

場合によっては、[マージにパイプラインの成功を必須にさせる](#require-a-successful-pipeline-for-merge)ことが可能であるにもかかわらず、失敗したパイプラインがないマージリクエストをマージできないことがあります。この設定では、失敗したパイプラインがないことではなく、成功したパイプラインがあることが必要となります。パイプラインがまったくないマージリクエストは、成功したパイプラインがあると見なされず、マージできません。

この設定を有効にする場合は、[`rules`](../../../ci/yaml/_index.md#rules)または[`workflow:rules`](../../../ci/yaml/_index.md#workflowrules)を使用して、すべてのマージリクエストに対してパイプラインが実行されるようにします。

### パイプラインが失敗しているにもかかわらず、マージリクエストをマージできる {#merge-request-can-still-be-merged-despite-a-failed-pipeline}

場合によっては、[マージにパイプラインの成功を必須にさせる](#require-a-successful-pipeline-for-merge)ことが可能であるのにもかかわらず、失敗したパイプラインでマージリクエストをマージできることがあります。

マージリクエストパイプラインは、**パイプラインが完了している**設定に対して最も高い優先度を持ちます。同じマージリクエストに対して複数のパイプラインタイプが実行される場合、GitLabは成功のためにマージリクエストパイプラインのみをチェックします。

マージリクエストには、次の場合に複数のパイプラインを含めることができます:

- [`rules`](../../../ci/yaml/_index.md#rules)設定により、1つのマージリクエストパイプラインと1つのブランチパイプラインという、[パイプラインの重複](../../../ci/jobs/job_rules.md#avoid-duplicate-pipelines)が発生します。この場合、最新のマージリクエストパイプラインの状態によって、マージリクエストがマージ可能かどうかが決まり、ブランチパイプラインは決定しません。
- マージリクエストと同じブランチをターゲットとする外部ツールによってトリガーされたパイプライン。

すべての場合において、同じマージリクエストに対して複数のパイプラインタイプが発生しないように、CI/CD設定を更新してください。
