/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.noverlap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.spi.LayoutData;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.plugin.noverlap.NoverlapLayoutData;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Exceptions;

public class NoverlapLayout
extends AbstractLayout
implements Layout,
LongTask {
    protected boolean cancel;
    protected Graph graph;
    private double speed;
    private double ratio;
    private double margin;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;

    public NoverlapLayout(LayoutBuilder layoutBuilder) {
        super(layoutBuilder);
    }

    public void initAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        this.setConverged(false);
        this.cancel = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goAlgo() {
        this.setConverged(true);
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        try {
            for (Node n : this.graph.getNodes()) {
                if (n.getLayoutData() == null || !(n.getLayoutData() instanceof NoverlapLayoutData)) {
                    n.setLayoutData((LayoutData)new NoverlapLayoutData());
                }
                NoverlapLayoutData layoutData = (NoverlapLayoutData)n.getLayoutData();
                layoutData.neighbours.clear();
                layoutData.dx = 0.0f;
                layoutData.dy = 0.0f;
            }
            this.xmin = Double.MAX_VALUE;
            this.xmax = Double.MIN_VALUE;
            this.ymin = Double.MAX_VALUE;
            this.ymax = Double.MIN_VALUE;
            for (Node n : this.graph.getNodes()) {
                float x = n.x();
                float y = n.y();
                float radius = n.size();
                double nxmin = (double)x - ((double)radius * this.ratio + this.margin);
                double nxmax = (double)x + ((double)radius * this.ratio + this.margin);
                double nymin = (double)y - ((double)radius * this.ratio + this.margin);
                double nymax = (double)y + ((double)radius * this.ratio + this.margin);
                this.xmin = Math.min(this.xmin, nxmin);
                this.xmax = Math.max(this.xmax, nxmax);
                this.ymin = Math.min(this.ymin, nymin);
                this.ymax = Math.max(this.ymax, nymax);
            }
            double xwidth = this.xmax - this.xmin;
            double yheight = this.ymax - this.ymin;
            double xcenter = (this.xmin + this.xmax) / 2.0;
            double ycenter = (this.ymin + this.ymax) / 2.0;
            double securityRatio = 1.1;
            this.xmin = xcenter - securityRatio * xwidth / 2.0;
            this.xmax = xcenter + securityRatio * xwidth / 2.0;
            this.ymin = ycenter - securityRatio * yheight / 2.0;
            this.ymax = ycenter + securityRatio * yheight / 2.0;
            SpatialGrid grid = new SpatialGrid();
            for (Node n : this.graph.getNodes()) {
                grid.add(n);
            }
            for (int row = 0; row < grid.countRows() && !this.cancel; ++row) {
                for (int col = 0; col < grid.countColumns() && !this.cancel; ++col) {
                    for (Node n : grid.getContent(row, col)) {
                        NoverlapLayoutData lald = (NoverlapLayoutData)n.getLayoutData();
                        for (int row2 = Math.max(0, row - 1); row2 <= Math.min(row + 1, grid.countRows() - 1); ++row2) {
                            for (int col2 = Math.max(0, col - 1); col2 <= Math.min(col + 1, grid.countColumns() - 1); ++col2) {
                                for (Node n2 : grid.getContent(row2, col2)) {
                                    if (n2 == n || lald.neighbours.contains(n2)) continue;
                                    lald.neighbours.add(n2);
                                }
                            }
                        }
                    }
                }
            }
            NodeIterable nodesIterable = this.graph.getNodes();
            for (Node n1 : nodesIterable) {
                NoverlapLayoutData lald = (NoverlapLayoutData)n1.getLayoutData();
                for (Node n2 : lald.neighbours) {
                    boolean collision;
                    float n1x = n1.x();
                    float n1y = n1.y();
                    float n2x = n2.x();
                    float n2y = n2.y();
                    float n1radius = n1.size();
                    float n2radius = n2.size();
                    double xDist = n2x - n1x;
                    double yDist = n2y - n1y;
                    double dist = Math.sqrt(xDist * xDist + yDist * yDist);
                    boolean bl = collision = dist < (double)n1radius * this.ratio + this.margin + ((double)n2radius * this.ratio + this.margin);
                    if (collision) {
                        this.setConverged(false);
                        NoverlapLayoutData layoutData = (NoverlapLayoutData)n2.getLayoutData();
                        double f = 1.0 + (double)n1.size();
                        if (dist > 0.0) {
                            layoutData.dx = (float)((double)layoutData.dx + xDist / dist * f);
                            layoutData.dy = (float)((double)layoutData.dy + yDist / dist * f);
                        } else {
                            layoutData.dx = (float)((double)layoutData.dx + 0.01 * (0.5 - Math.random()));
                            layoutData.dy = (float)((double)layoutData.dy + 0.01 * (0.5 - Math.random()));
                        }
                    }
                    if (!this.cancel) continue;
                    break;
                }
                if (!this.cancel) continue;
                nodesIterable.doBreak();
                break;
            }
            for (Node n : this.graph.getNodes()) {
                NoverlapLayoutData layoutData = (NoverlapLayoutData)n.getLayoutData();
                if (n.isFixed()) continue;
                layoutData.dx = (float)((double)layoutData.dx * (0.1 * this.speed));
                layoutData.dy = (float)((double)layoutData.dy * (0.1 * this.speed));
                float x = n.x() + layoutData.dx;
                float y = n.y() + layoutData.dy;
                n.setX(x);
                n.setY(y);
            }
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    public void endAlgo() {
        this.graph.readLock();
        try {
            for (Node n : this.graph.getNodes()) {
                n.setLayoutData(null);
            }
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        String NOVERLAP_CATEGORY = "Noverlap";
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)"speed", (String)"Noverlap", (String)"speed", (String)"getSpeed", (String)"setSpeed"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)"ratio", (String)"Noverlap", (String)"ratio", (String)"getRatio", (String)"setRatio"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)"margin", (String)"Noverlap", (String)"margin", (String)"getMargin", (String)"setMargin"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public void resetPropertiesValues() {
        this.setSpeed(3.0);
        this.setRatio(1.2);
        this.setMargin(5.0);
    }

    public Double getSpeed() {
        return this.speed;
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    public Double getRatio() {
        return this.ratio;
    }

    public void setRatio(Double ratio) {
        this.ratio = ratio;
    }

    public Double getMargin() {
        return this.margin;
    }

    public void setMargin(Double margin) {
        this.margin = margin;
    }

    public boolean cancel() {
        this.cancel = true;
        return this.cancel;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
    }

    private class SpatialGrid {
        private final int COLUMNS_ROWS = 20;
        private final Map<Cell, List<Node>> data = new HashMap<Cell, List<Node>>();

        public SpatialGrid() {
            for (int row = 0; row < 20; ++row) {
                for (int col = 0; col < 20; ++col) {
                    ArrayList localnodes = new ArrayList();
                    this.data.put(new Cell(row, col), localnodes);
                }
            }
        }

        public Iterable<Node> getContent(int row, int col) {
            return this.data.get(new Cell(row, col));
        }

        public int countColumns() {
            return 20;
        }

        public int countRows() {
            return 20;
        }

        public void add(Node node) {
            float x = node.x();
            float y = node.y();
            float radius = node.size();
            double nxmin = (double)x - ((double)radius * NoverlapLayout.this.ratio + NoverlapLayout.this.margin);
            double nxmax = (double)x + ((double)radius * NoverlapLayout.this.ratio + NoverlapLayout.this.margin);
            double nymin = (double)y - ((double)radius * NoverlapLayout.this.ratio + NoverlapLayout.this.margin);
            double nymax = (double)y + ((double)radius * NoverlapLayout.this.ratio + NoverlapLayout.this.margin);
            int minXbox = (int)Math.floor(19.0 * (nxmin - NoverlapLayout.this.xmin) / (NoverlapLayout.this.xmax - NoverlapLayout.this.xmin));
            int maxXbox = (int)Math.floor(19.0 * (nxmax - NoverlapLayout.this.xmin) / (NoverlapLayout.this.xmax - NoverlapLayout.this.xmin));
            int minYbox = (int)Math.floor(19.0 * (nymin - NoverlapLayout.this.ymin) / (NoverlapLayout.this.ymax - NoverlapLayout.this.ymin));
            int maxYbox = (int)Math.floor(19.0 * (nymax - NoverlapLayout.this.ymin) / (NoverlapLayout.this.ymax - NoverlapLayout.this.ymin));
            for (int col = minXbox; col <= maxXbox; ++col) {
                for (int row = minYbox; row <= maxYbox; ++row) {
                    try {
                        this.data.get(new Cell(row, col)).add(node);
                        continue;
                    }
                    catch (Exception e) {
                        if (nxmin < NoverlapLayout.this.xmin || nxmax > NoverlapLayout.this.xmax) {
                            // empty if block
                        }
                        if (!(nymin < NoverlapLayout.this.ymin) && !(nymax > NoverlapLayout.this.ymax)) continue;
                    }
                }
            }
        }
    }

    private static class Cell {
        private final int row;
        private final int col;

        public Cell(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Cell other = (Cell)obj;
            if (this.row != other.row) {
                return false;
            }
            return this.col == other.col;
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + this.row;
            hash = 11 * hash + this.col;
            return hash;
        }
    }
}

