/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.statistics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.gephi.desktop.statistics.StatisticsCategory;
import org.gephi.desktop.statistics.StatisticsFrontEnd;
import org.gephi.desktop.statistics.api.StatisticsModelUI;
import org.gephi.statistics.spi.StatisticsUI;
import org.gephi.ui.components.JSqueezeBoxPanel;
import org.openide.util.Lookup;

public class StatisticsPanel
extends JPanel {
    private StatisticsCategory[] categories;
    private List<UIFrontEnd> frontEnds;
    private JSqueezeBoxPanel squeezeBoxPanel;

    public StatisticsPanel() {
        this.initComponents();
        this.initCategories();
        this.initFrontEnds();
    }

    public void refreshModel(StatisticsModelUI model) {
        boolean needRefreshVisible = false;
        for (UIFrontEnd entry : this.frontEnds) {
            boolean visible;
            entry.getFrontEnd().refreshModel(model);
            if (model == null || (visible = model.isStatisticsUIVisible(entry.getStatisticsUI())) == entry.visible) continue;
            needRefreshVisible = true;
            entry.setVisible(visible);
        }
        if (needRefreshVisible) {
            this.refreshFrontEnd();
        }
    }

    private void refreshFrontEnd() {
        this.squeezeBoxPanel.cleanPanels();
        for (StatisticsCategory category : this.categories) {
            ArrayList<UIFrontEnd> uis = new ArrayList<UIFrontEnd>();
            for (UIFrontEnd uife : this.frontEnds) {
                if (!uife.getCategory().equals(category) || !uife.isVisible()) continue;
                uis.add(uife);
            }
            if (uis.size() <= 0) continue;
            Collections.sort(uis, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Integer p1 = ((UIFrontEnd)o1).getStatisticsUI().getPosition();
                    Integer p2 = ((UIFrontEnd)o2).getStatisticsUI().getPosition();
                    return p1.compareTo(p2);
                }
            });
            MigLayout migLayout = new MigLayout("insets 0");
            migLayout.setColumnConstraints((Object)"[grow,fill]");
            migLayout.setRowConstraints((Object)"[pref!]");
            JPanel innerPanel = new JPanel((LayoutManager)migLayout);
            for (UIFrontEnd sui : uis) {
                innerPanel.add((Component)sui.frontEnd, "wrap");
            }
            this.squeezeBoxPanel.addPanel(innerPanel, category.getName());
        }
    }

    private void initFrontEnds() {
        StatisticsUI[] statisticsUIs = Lookup.getDefault().lookupAll(StatisticsUI.class).toArray(new StatisticsUI[0]);
        this.frontEnds = new ArrayList<UIFrontEnd>();
        for (StatisticsCategory category : this.categories) {
            ArrayList<StatisticsUI> uis = new ArrayList<StatisticsUI>();
            for (StatisticsUI sui : statisticsUIs) {
                if (!sui.getCategory().equals(category.getName())) continue;
                uis.add(sui);
            }
            if (uis.size() <= 0) continue;
            Collections.sort(uis, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Integer p1 = ((StatisticsUI)o1).getPosition();
                    Integer p2 = ((StatisticsUI)o2).getPosition();
                    return p1.compareTo(p2);
                }
            });
            MigLayout migLayout = new MigLayout("insets 0");
            migLayout.setColumnConstraints((Object)"[grow,fill]");
            migLayout.setRowConstraints((Object)"[pref!]");
            JPanel innerPanel = new JPanel((LayoutManager)migLayout);
            for (StatisticsUI sui : uis) {
                StatisticsFrontEnd frontEnd = new StatisticsFrontEnd(sui);
                UIFrontEnd uife = new UIFrontEnd(sui, frontEnd, category);
                this.frontEnds.add(uife);
                innerPanel.add((Component)frontEnd, "wrap");
            }
            this.squeezeBoxPanel.addPanel(innerPanel, category.getName());
        }
    }

    private void initCategories() {
        LinkedHashMap<String, StatisticsCategory> cats = new LinkedHashMap<String, StatisticsCategory>();
        cats.put(StatisticsUI.CATEGORY_NETWORK_OVERVIEW, new StatisticsCategory(StatisticsUI.CATEGORY_NETWORK_OVERVIEW, 100));
        cats.put(StatisticsUI.CATEGORY_COMMUNITY_DETECTION, new StatisticsCategory(StatisticsUI.CATEGORY_COMMUNITY_DETECTION, 150));
        cats.put(StatisticsUI.CATEGORY_NODE_OVERVIEW, new StatisticsCategory(StatisticsUI.CATEGORY_NODE_OVERVIEW, 200));
        cats.put(StatisticsUI.CATEGORY_EDGE_OVERVIEW, new StatisticsCategory(StatisticsUI.CATEGORY_EDGE_OVERVIEW, 300));
        cats.put(StatisticsUI.CATEGORY_DYNAMIC, new StatisticsCategory(StatisticsUI.CATEGORY_DYNAMIC, 400));
        int position = 500;
        for (StatisticsUI uis : Lookup.getDefault().lookupAll(StatisticsUI.class)) {
            String category = uis.getCategory();
            if (cats.containsKey(category)) continue;
            cats.put(category, new StatisticsCategory(category, position));
            position += 100;
        }
        this.categories = cats.values().toArray(new StatisticsCategory[0]);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.squeezeBoxPanel = new JSqueezeBoxPanel();
        this.add((Component)this.squeezeBoxPanel, "Center");
    }

    public StatisticsCategory[] getCategories() {
        return this.categories;
    }

    private static class UIFrontEnd {
        private final StatisticsUI statisticsUI;
        private final StatisticsFrontEnd frontEnd;
        private final StatisticsCategory category;
        private boolean visible;

        public UIFrontEnd(StatisticsUI statisticsUI, StatisticsFrontEnd frontEnd, StatisticsCategory category) {
            this.statisticsUI = statisticsUI;
            this.frontEnd = frontEnd;
            this.category = category;
            this.visible = true;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public StatisticsFrontEnd getFrontEnd() {
            return this.frontEnd;
        }

        public StatisticsUI getStatisticsUI() {
            return this.statisticsUI;
        }

        public StatisticsCategory getCategory() {
            return this.category;
        }
    }
}

