/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSMediaRule;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.impl.MediaListAccess;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.GroupingRule;
import io.sf.carte.doc.style.css.om.RuleStore;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRuleList;

public class MediaRule
extends GroupingRule
implements CSSMediaRule {
    private static final long serialVersionUID = 1L;
    private MediaQueryList mediaList = null;

    protected MediaRule(AbstractCSSStyleSheet parentSheet, MediaQueryList mediaList, int origin) {
        super(parentSheet, (short)4, origin);
        this.cssRules = new CSSRuleArrayList();
        this.mediaList = mediaList;
    }

    MediaRule(AbstractCSSStyleSheet parentSheet, MediaRule copyfrom) {
        super(parentSheet, copyfrom);
        this.mediaList = ((MediaListAccess)((Object)copyfrom.getMedia())).unmodifiable();
    }

    @Override
    public MediaQueryList getMedia() {
        return this.mediaList;
    }

    @Override
    int addRuleList(CSSRuleArrayList otherRules, int importCount) {
        int orl = otherRules.getLength();
        for (int i = 0; i < orl; ++i) {
            AbstractCSSRule oRule = (AbstractCSSRule)otherRules.item(i);
            importCount = oRule.addToMediaRule(this, importCount);
        }
        return importCount;
    }

    @Override
    void prioritySplit(AbstractCSSStyleSheet importantSheet, AbstractCSSStyleSheet normalSheet, RuleStore importantStore, RuleStore normalStore) {
        MediaRule impRule = importantSheet.createMediaRule(this.mediaList);
        MediaRule normalRule = importantSheet.createMediaRule(this.mediaList);
        super.prioritySplit(importantSheet, normalSheet, impRule, normalRule);
        if (!((ArrayList)((Object)impRule.getCssRules())).isEmpty()) {
            importantStore.addRule(impRule);
        }
        if (!((ArrayList)((Object)normalRule.getCssRules())).isEmpty()) {
            normalStore.addRule(normalRule);
        }
    }

    @Override
    void cascade(BaseDocumentCSSStyleSheet.Cascade cascade, SelectorMatcher matcher, ComputedCSSStyle style, String targetMedium) {
        MediaQueryList mediaList = this.getMedia();
        if (((MediaListAccess)((Object)mediaList)).hasProxy()) {
            mediaList = this.replaceProxyFeatures(mediaList, style);
        }
        if (mediaList.matches(targetMedium, this.getCanvas())) {
            CSSRuleList ruleList = this.getCssRules();
            ((CSSRuleArrayList)ruleList).cascade(cascade, matcher, style, targetMedium);
        }
    }

    private MediaQueryList replaceProxyFeatures(MediaQueryList mql, ComputedCSSStyle style) {
        return mql;
    }

    private CSSCanvas getCanvas() {
        Node owner = this.getParentStyleSheet().getOwnerNode();
        CSSCanvas canvas = null;
        if (owner != null) {
            CSSDocument doc = (CSSDocument)owner.getOwnerDocument();
            if (doc == null) {
                doc = (CSSDocument)owner;
            }
            canvas = doc.getCanvas();
        }
        return canvas;
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(64 + ((CSSRuleArrayList)this.getCssRules()).getLength() * 36);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder sb = new StringBuilder(30 + ((CSSRuleArrayList)this.getCssRules()).getLength() * 20);
        sb.append("@media");
        if (!this.mediaList.isAllMedia()) {
            sb.append(' ').append(this.mediaList.getMinifiedMedia());
        }
        sb.append("{");
        Iterator it = ((ArrayList)((Object)this.getCssRules())).iterator();
        while (it.hasNext()) {
            sb.append(((AbstractCSSRule)it.next()).getMinifiedCssText());
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        context.startRule(wri, this.getPrecedingComments());
        wri.write((CharSequence)"@media");
        if (!this.mediaList.isAllMedia()) {
            wri.write(' ');
            wri.write((CharSequence)this.mediaList.getMedia());
        }
        context.updateContext(this);
        context.writeLeftCurlyBracket(wri);
        ((CSSRuleArrayList)this.getCssRules()).writeCssText(wri, context);
        context.endCurrentContext(this);
        context.endRuleList(wri);
        context.writeRightCurlyBracket(wri);
        context.endRule(wri, this.getTrailingComments());
    }

    @Override
    boolean hasErrorsOrWarnings() {
        return super.hasErrorsOrWarnings() || this.mediaList != null && this.mediaList.hasErrors();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mediaList == null ? 0 : this.mediaList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaRule other = (MediaRule)obj;
        return !(this.mediaList == null ? other.mediaList != null : !this.mediaList.equals(other.mediaList));
    }

    @Override
    public MediaRule clone(AbstractCSSStyleSheet parentSheet) {
        return new MediaRule(parentSheet, this);
    }
}

