/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.knopflerfish.framework.Util;

public class IteratorIteratorSorted<A>
implements Iterator<A> {
    private final Iterator<A>[] iter;
    private final A[] top;
    private final Util.Comparator<A, A> comp;
    int size;

    public IteratorIteratorSorted(List<Iterator<A>> ilist, Util.Comparator<A, A> comp) {
        this.comp = comp;
        this.size = ilist.size();
        Iterator[] iters = new Iterator[this.size + 1];
        this.iter = iters;
        Object[] topA = new Object[this.size + 1];
        this.top = topA;
        int pos = 1;
        for (Iterator<A> si : ilist) {
            if (si.hasNext()) {
                this.top[pos] = si.next();
                this.iter[pos++] = si;
                continue;
            }
            --this.size;
        }
        for (pos = this.size / 2; pos > 0; --pos) {
            this.balance(pos);
        }
    }

    @Override
    public boolean hasNext() {
        return this.size > 0;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public A next() {
        if (this.hasNext()) {
            A res = this.top[1];
            if (this.iter[1].hasNext()) {
                this.top[1] = this.iter[1].next();
            } else {
                this.top[1] = this.top[this.size];
                this.iter[1] = this.iter[this.size--];
            }
            this.balance(1);
            return res;
        }
        throw new NoSuchElementException();
    }

    private void balance(int current) {
        A tmp = this.top[current];
        Iterator<A> itmp = this.iter[current];
        while (current * 2 <= this.size) {
            int child = current * 2;
            if (child != this.size && this.comp.compare(this.top[child + 1], this.top[child]) > 0) {
                ++child;
            }
            if (this.comp.compare(this.top[child], tmp) <= 0) break;
            this.top[current] = this.top[child];
            this.iter[current] = this.iter[child];
            current = child;
        }
        this.top[current] = tmp;
        this.iter[current] = itmp;
    }
}

