/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.NativeTrade;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIServerAPI;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.networking.DummyConnection;

public abstract class AIPlayer
extends AIObject {
    private static final Logger logger = Logger.getLogger(AIPlayer.class.getName());
    public static final String TAG = "aiPlayer";
    private static final Runnable nullRunnable = () -> {};
    private static final Comparator<AIUnit> aiUnitLocationComparator = Comparator.comparing(AIUnit::getUnit, Unit.locComparator);
    private Player player;
    private Random aiRandom;
    private AIServerAPI serverAPI;
    private static final String RANDOM_STATE_TAG = "randomState";

    protected AIPlayer(AIMain aiMain, Player player) {
        super(aiMain, player.getId());
        this.player = player;
        this.aiRandom = new Random(aiMain.getRandomSeed("Seed for " + this.getId()));
        this.serverAPI = new AIServerAPI(this);
        this.setInitialized();
    }

    public AIPlayer(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
        this.serverAPI = new AIServerAPI(this);
        this.setInitialized();
    }

    @Override
    public final void setInitialized() {
        this.initialized = this.getPlayer() != null;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Random getAIRandom() {
        return this.aiRandom;
    }

    protected String getAIAdvantage() {
        String prefix = "model.nationType.";
        String id = this.player == null || this.player.getNationType() == null ? "" : this.player.getNationType().getId();
        return id.startsWith("model.nationType.") ? id.substring("model.nationType.".length()) : "";
    }

    public Connection getConnection() {
        return ((DummyConnection)this.player.getConnection()).getOtherConnection();
    }

    public AIServerAPI askServer() {
        return this.serverAPI;
    }

    public void removeAIObject(AIObject ao) {
    }

    public AIColony getAIColony(Colony colony) {
        return this.getAIMain().getAIColony(colony);
    }

    public List<AIColony> getAIColonies() {
        AIMain aiMain = this.getAIMain();
        return CollectionUtils.transform(this.getPlayer().getColonies(), CollectionUtils.alwaysTrue(), c -> aiMain.getAIColony((Colony)c), CollectionUtils.toListNoNulls());
    }

    protected AIUnit getAIUnit(Unit unit) {
        return this.getAIMain().getAIUnit(unit);
    }

    protected List<AIUnit> getAIUnits() {
        ArrayList<AIUnit> aiUnits = new ArrayList<AIUnit>();
        for (Unit u : this.getPlayer().getUnitSet()) {
            if (u.isDisposed()) {
                logger.warning("getAIUnits ignoring: " + u.getId());
                continue;
            }
            AIUnit a = this.getAIUnit(u);
            if (a != null) {
                if (a.getUnit() != u) {
                    throw new IllegalStateException("getAIUnits fail: " + u + "/" + a);
                }
                aiUnits.add(a);
                continue;
            }
            logger.warning("Could not find the AIUnit for: " + u + " (" + u.getId() + ")");
        }
        return aiUnits;
    }

    protected Stance determineStance(Player other) {
        return this.player.getStance(other).getStanceFromTension(this.player.getTension(other));
    }

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        if (this.player == null || this.player.isDisposed()) {
            lb.add("\n  AIPlayer without underlying player: ", this.getId());
            result = result.fail();
        } else if (!this.player.isAI()) {
            lb.add("\n  AIPlayer that is not an AI: ", this.getId());
            result = result.fail();
        }
        return result;
    }

    protected void invoke(Runnable runnable) {
        Thread thread = new Thread(runnable, "FreeColServer:AIPlayer(" + this.getPlayer().getName() + ")");
        thread.start();
        logger.finest("Started " + thread);
    }

    public void chooseFoundingFatherHandler(List<FoundingFather> fathers) {
        FoundingFather ff = this.selectFoundingFather(fathers);
        if (ff == null) {
            return;
        }
        logger.finest(this.getId() + " chose founding father: " + ff);
        this.invoke(() -> AIMessage.askChooseFoundingFather(this, fathers, ff));
    }

    public void diplomacyHandler(FreeColGameObject our, FreeColGameObject other, DiplomaticTrade agreement) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("AI Diplomacy: ").append(agreement);
        switch (agreement.getStatus()) {
            case PROPOSE_TRADE: {
                agreement.setStatus(this.acceptDiplomaticTrade(agreement));
                sb.append(" -> ").append(agreement);
                logger.fine(sb.toString());
                break;
            }
            default: {
                sb.append(" -> ignoring ").append((Object)agreement.getStatus());
                logger.fine(sb.toString());
                return;
            }
        }
        this.invoke(() -> AIMessage.askDiplomacy(this, our, other, agreement));
    }

    public void firstContactHandler(Player contactor, Player contactee, Tile tile) {
        this.invoke(() -> AIMessage.askFirstContact(this, contactor, contactee, tile, true));
    }

    public void fountainOfYouthHandler(int n) {
        this.invoke(() -> {
            for (int i = 0; i < n; ++i) {
                AIMessage.askEmigrate(this, 0);
            }
        });
    }

    public void indianDemandHandler(Unit unit, Colony colony, GoodsType type, int amount, Constants.IndianDemandAction initial) {
        Constants.IndianDemandAction result = this.indianDemand(unit, colony, type, amount, initial);
        logger.finest("AI handling native demand by " + unit + " at " + colony + " result: " + initial + " -> " + result);
        if (result != Constants.IndianDemandAction.INDIAN_DEMAND_DONE) {
            this.invoke(() -> AIMessage.askIndianDemand(this, unit, colony, type, amount, result));
        }
    }

    public void lootCargoHandler(Unit unit, List<Goods> initialGoods, String defenderId) {
        Market market = this.getPlayer().getMarket();
        List<Goods> goods = CollectionUtils.sort(initialGoods, market.getSalePriceComparator());
        ArrayList<Goods> loot = new ArrayList<Goods>();
        int space = unit.getSpaceLeft();
        while (space > 0 && !goods.isEmpty()) {
            Goods g = goods.remove(0);
            if (g.getSpaceTaken() > space) continue;
            loot.add(g);
            space -= g.getSpaceTaken();
        }
        this.invoke(() -> AIMessage.askLoot(this.getAIUnit(unit), defenderId, loot));
    }

    public void monarchActionHandler(Monarch.MonarchAction action, int tax) {
        boolean accept;
        switch (action) {
            case RAISE_TAX_WAR: 
            case RAISE_TAX_ACT: {
                accept = this.acceptTax(tax);
                break;
            }
            case MONARCH_MERCENARIES: 
            case HESSIAN_MERCENARIES: {
                accept = this.acceptMercenaries();
                break;
            }
            default: {
                logger.finest("AI player ignoring monarch action " + action);
                return;
            }
        }
        logger.finest("AI player monarch action " + action + " = " + accept);
        this.invoke(() -> AIMessage.askMonarchAction(this, action, accept));
    }

    public void nationSummaryHandler(Player other, NationSummary ns) {
        this.getPlayer().putNationSummary(other, ns);
        logger.info("Updated nation summary of " + other.getSuffix() + " for AI " + this.player.getSuffix());
    }

    public void nativeTradeHandler(NativeTrade.NativeTradeAction action, NativeTrade nt) {
        this.invoke(() -> {
            NativeTrade.NativeTradeAction result = this.handleTrade(action, nt);
            AIMessage.askNativeTrade(this, result, nt);
        });
    }

    public void newLandNameHandler(Unit unit, String name) {
        this.invoke(() -> AIMessage.askNewLandName(this, unit, name));
    }

    public void newRegionNameHandler(Region region, Tile tile, Unit unit, String name) {
        this.invoke(() -> AIMessage.askNewRegionName(this, region, tile, unit, name));
    }

    public void reconnectHandler() {
        logger.warning("Reconnect");
    }

    public void setAIHandler(Player player, boolean ai) {
        player.setAI(ai);
    }

    public void setCurrentPlayerHandler(Player currentPlayer) {
        if (this.getPlayer().getId().equals(currentPlayer.getId())) {
            this.invoke(() -> {
                try {
                    this.startWorking();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unhandled exception from the AI. The AI's turn has been ended prematurely.", e);
                    this.askServer().chat(currentPlayer, Messages.message("ai.chat.stoppedWorking"));
                }
                AIMessage.askEndTurn(this);
            });
        }
    }

    public abstract void startWorking();

    public Constants.IndianDemandAction indianDemand(Unit unit, Colony colony, GoodsType type, int amount, Constants.IndianDemandAction accept) {
        return Constants.IndianDemandAction.INDIAN_DEMAND_REJECT;
    }

    public DiplomaticTrade.TradeStatus acceptDiplomaticTrade(DiplomaticTrade agreement) {
        return DiplomaticTrade.TradeStatus.REJECT_TRADE;
    }

    public abstract NativeTrade.NativeTradeAction handleTrade(NativeTrade.NativeTradeAction var1, NativeTrade var2);

    public boolean acceptTax(int tax) {
        return false;
    }

    public boolean acceptMercenaries() {
        return false;
    }

    public FoundingFather selectFoundingFather(List<FoundingFather> ffs) {
        return null;
    }

    public abstract int getNeededWagons(Tile var1);

    public abstract int pioneersNeeded();

    public abstract int scoutsNeeded();

    public abstract void completeWish(Wish var1);

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        String rs;
        super.writeAttributes(xw);
        try {
            rs = Utils.getRandomState(this.aiRandom);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Could not get random state", ioe);
            return;
        }
        xw.writeAttribute(RANDOM_STATE_TAG, rs);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        AIMain aiMain = this.getAIMain();
        this.player = xr.findFreeColGameObject(aiMain.getGame(), "id", ServerPlayer.class, null, true);
        Random rnd = Utils.restoreRandomState(xr.getAttribute(RANDOM_STATE_TAG, null));
        this.aiRandom = rnd != null ? rnd : new Random(aiMain.getRandomSeed("Seed for " + this.getId()));
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

