/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

public class EmbarkMessage
extends AttributeMessage {
    public static final String TAG = "embark";
    private static final String CARRIER_TAG = "carrier";
    private static final String DIRECTION_TAG = "direction";
    private static final String UNIT_TAG = "unit";

    public EmbarkMessage(Unit unit, Unit carrier, Direction direction) {
        super(TAG, UNIT_TAG, unit.getId(), CARRIER_TAG, carrier.getId(), DIRECTION_TAG, direction == null ? null : String.valueOf(direction));
    }

    public EmbarkMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, CARRIER_TAG, DIRECTION_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Unit carrier;
        ServerUnit unit;
        String unitId = this.getStringAttribute(UNIT_TAG);
        String carrierId = this.getStringAttribute(CARRIER_TAG);
        String directionString = this.getStringAttribute(DIRECTION_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, ServerUnit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        try {
            carrier = serverPlayer.getOurFreeColGameObject(carrierId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        Location sourceLocation = unit.getLocation();
        if (directionString == null) {
            if (!carrier.isAtLocation(sourceLocation)) {
                return serverPlayer.clientError("Unit " + unitId + " at " + sourceLocation.getId() + " and carrier " + carrierId + " at " + carrier.getLocation().getId() + " are not co-located.");
            }
        } else {
            if (unit.getMovesLeft() <= 0) {
                return serverPlayer.clientError("Unit has no moves left: " + unitId);
            }
            Tile destinationTile = null;
            try {
                destinationTile = unit.getNeighbourTile(directionString);
            }
            catch (Exception e) {
                return serverPlayer.clientError(e.getMessage());
            }
            if (carrier.getTile() != destinationTile) {
                return serverPlayer.clientError("Carrier: " + carrierId + " is not at destination tile: " + destinationTile);
            }
        }
        return this.igc(freeColServer).embarkUnit(serverPlayer, unit, carrier);
    }
}

