/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Set;
import org.apache.coyote.BadRequestException;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.res.StringManager;

public class ChunkedInputFilter
implements InputFilter,
ApplicationBufferHandler {
    private static final StringManager sm = StringManager.getManager(ChunkedInputFilter.class);
    protected static final String ENCODING_NAME = "chunked";
    protected static final ByteChunk ENCODING = new ByteChunk();
    protected InputBuffer buffer;
    protected int remaining = 0;
    protected ByteBuffer readChunk;
    protected boolean endChunk = false;
    protected final ByteChunk trailingHeaders = new ByteChunk();
    protected boolean needCRLFParse = false;
    private Request request;
    private final long maxExtensionSize;
    private final int maxTrailerSize;
    private long extensionSize;
    private final int maxSwallowSize;
    private boolean error;
    private final Set<String> allowedTrailerHeaders;

    public ChunkedInputFilter(int n, Set<String> set, int n2, int n3) {
        this.trailingHeaders.setLimit(n);
        this.allowedTrailerHeaders = set;
        this.maxExtensionSize = n2;
        this.maxTrailerSize = n;
        this.maxSwallowSize = n3;
    }

    @Override
    @Deprecated
    public int doRead(ByteChunk byteChunk) throws IOException {
        if (this.endChunk) {
            return -1;
        }
        this.checkError();
        if (this.needCRLFParse) {
            this.needCRLFParse = false;
            this.parseCRLF(false);
        }
        if (this.remaining <= 0) {
            if (!this.parseChunkHeader()) {
                this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidHeader"));
            }
            if (this.endChunk) {
                this.parseEndChunk();
                return -1;
            }
        }
        int n = 0;
        if ((this.readChunk == null || this.readChunk.position() >= this.readChunk.limit()) && this.readBytes() < 0) {
            this.throwEOFException(sm.getString("chunkedInputFilter.eos"));
        }
        if (this.remaining > this.readChunk.remaining()) {
            n = this.readChunk.remaining();
            this.remaining -= n;
            byteChunk.setBytes(this.readChunk.array(), this.readChunk.arrayOffset() + this.readChunk.position(), n);
            this.readChunk.position(this.readChunk.limit());
        } else {
            n = this.remaining;
            byteChunk.setBytes(this.readChunk.array(), this.readChunk.arrayOffset() + this.readChunk.position(), this.remaining);
            this.readChunk.position(this.readChunk.position() + this.remaining);
            this.remaining = 0;
            if (this.readChunk.position() + 1 >= this.readChunk.limit()) {
                this.needCRLFParse = true;
            } else {
                this.parseCRLF(false);
            }
        }
        return n;
    }

    @Override
    public int doRead(ApplicationBufferHandler applicationBufferHandler) throws IOException {
        if (this.endChunk) {
            return -1;
        }
        this.checkError();
        if (this.needCRLFParse) {
            this.needCRLFParse = false;
            this.parseCRLF(false);
        }
        if (this.remaining <= 0) {
            if (!this.parseChunkHeader()) {
                this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidHeader"));
            }
            if (this.endChunk) {
                this.parseEndChunk();
                return -1;
            }
        }
        int n = 0;
        if ((this.readChunk == null || this.readChunk.position() >= this.readChunk.limit()) && this.readBytes() < 0) {
            this.throwEOFException(sm.getString("chunkedInputFilter.eos"));
        }
        if (this.remaining > this.readChunk.remaining()) {
            n = this.readChunk.remaining();
            this.remaining -= n;
            if (this.readChunk != applicationBufferHandler.getByteBuffer()) {
                applicationBufferHandler.setByteBuffer(this.readChunk.duplicate());
            }
            this.readChunk.position(this.readChunk.limit());
        } else {
            n = this.remaining;
            if (this.readChunk != applicationBufferHandler.getByteBuffer()) {
                applicationBufferHandler.setByteBuffer(this.readChunk.duplicate());
                applicationBufferHandler.getByteBuffer().limit(this.readChunk.position() + this.remaining);
            }
            this.readChunk.position(this.readChunk.position() + this.remaining);
            this.remaining = 0;
            if (this.readChunk.position() + 1 >= this.readChunk.limit()) {
                this.needCRLFParse = true;
            } else {
                this.parseCRLF(false);
            }
        }
        return n;
    }

    @Override
    public void setRequest(Request request) {
        this.request = request;
    }

    @Override
    public long end() throws IOException {
        long l = 0L;
        int n = 0;
        while ((n = this.doRead(this)) >= 0) {
            if (this.maxSwallowSize <= -1 || (l += (long)n) <= (long)this.maxSwallowSize) continue;
            this.throwBadRequestException(sm.getString("inputFilter.maxSwallow"));
        }
        return this.readChunk.remaining();
    }

    @Override
    public int available() {
        int n = 0;
        if (this.readChunk != null) {
            n = this.readChunk.remaining();
        }
        if (n == 0) {
            return this.buffer.available();
        }
        return n;
    }

    @Override
    public void setBuffer(InputBuffer inputBuffer) {
        this.buffer = inputBuffer;
    }

    @Override
    public void recycle() {
        this.remaining = 0;
        if (this.readChunk != null) {
            this.readChunk.position(0).limit(0);
        }
        this.endChunk = false;
        this.needCRLFParse = false;
        this.trailingHeaders.recycle();
        this.trailingHeaders.setLimit(this.maxTrailerSize);
        this.extensionSize = 0L;
        this.error = false;
    }

    @Override
    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    @Override
    public boolean isFinished() {
        return this.endChunk;
    }

    protected int readBytes() throws IOException {
        return this.buffer.doRead(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean parseChunkHeader() throws IOException {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = false;
        while (!bl) {
            if ((this.readChunk == null || this.readChunk.position() >= this.readChunk.limit()) && this.readBytes() <= 0) {
                return false;
            }
            byte by = this.readChunk.get(this.readChunk.position());
            if (by == 13 || by == 10) {
                this.parseCRLF(false);
                bl = true;
            } else if (by == 59 && !bl2) {
                bl2 = true;
                ++this.extensionSize;
            } else if (!bl2) {
                int n3 = HexUtils.getDec((int)by);
                if (n3 == -1 || n2 >= 8) return false;
                ++n2;
                n = n << 4 | n3;
            } else {
                ++this.extensionSize;
                if (this.maxExtensionSize > -1L && this.extensionSize > this.maxExtensionSize) {
                    this.throwBadRequestException(sm.getString("chunkedInputFilter.maxExtension"));
                }
            }
            if (bl) continue;
            this.readChunk.position(this.readChunk.position() + 1);
        }
        if (n2 == 0 || n < 0) {
            return false;
        }
        if (n == 0) {
            this.endChunk = true;
        }
        this.remaining = n;
        return true;
    }

    protected void parseCRLF(boolean bl) throws IOException {
        boolean bl2 = false;
        boolean bl3 = false;
        while (!bl2) {
            byte by;
            if ((this.readChunk == null || this.readChunk.position() >= this.readChunk.limit()) && this.readBytes() <= 0) {
                this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidCrlfNoData"));
            }
            if ((by = this.readChunk.get(this.readChunk.position())) == 13) {
                if (bl3) {
                    this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidCrlfCRCR"));
                }
                bl3 = true;
            } else if (by == 10) {
                if (!bl && !bl3) {
                    this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidCrlfNoCR"));
                }
                bl2 = true;
            } else {
                this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidCrlf"));
            }
            this.readChunk.position(this.readChunk.position() + 1);
        }
    }

    protected void parseEndChunk() throws IOException {
        while (this.parseHeader()) {
        }
    }

    private boolean parseHeader() throws IOException {
        MimeHeaders mimeHeaders = this.request.getMimeHeaders();
        byte by = 0;
        if ((this.readChunk == null || this.readChunk.position() >= this.readChunk.limit()) && this.readBytes() < 0) {
            this.throwEOFException(sm.getString("chunkedInputFilter.eosTrailer"));
        }
        if ((by = this.readChunk.get(this.readChunk.position())) == 13 || by == 10) {
            this.parseCRLF(false);
            return false;
        }
        int n = this.trailingHeaders.getEnd();
        boolean bl = false;
        while (!bl) {
            if ((this.readChunk == null || this.readChunk.position() >= this.readChunk.limit()) && this.readBytes() < 0) {
                this.throwEOFException(sm.getString("chunkedInputFilter.eosTrailer"));
            }
            if ((by = this.readChunk.get(this.readChunk.position())) >= 65 && by <= 90) {
                by = (byte)(by - -32);
            }
            if (by == 58) {
                bl = true;
            } else if (!HttpParser.isToken(by)) {
                this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidTrailerHeaderName"));
            } else if (this.trailingHeaders.getEnd() >= this.trailingHeaders.getLimit()) {
                this.throwBadRequestException(sm.getString("chunkedInputFilter.maxTrailer"));
            } else {
                this.trailingHeaders.append(by);
            }
            this.readChunk.position(this.readChunk.position() + 1);
        }
        int n2 = this.trailingHeaders.getEnd();
        boolean bl2 = false;
        boolean bl3 = true;
        int n3 = 0;
        while (bl3) {
            boolean bl4 = true;
            while (bl4) {
                if ((this.readChunk == null || this.readChunk.position() >= this.readChunk.limit()) && this.readBytes() < 0) {
                    this.throwEOFException(sm.getString("chunkedInputFilter.eosTrailer"));
                }
                if ((by = this.readChunk.get(this.readChunk.position())) == 32 || by == 9) {
                    this.readChunk.position(this.readChunk.position() + 1);
                    int n4 = this.trailingHeaders.getLimit() - 1;
                    if (this.trailingHeaders.getEnd() > n4) {
                        this.throwBadRequestException(sm.getString("chunkedInputFilter.maxTrailer"));
                    }
                    this.trailingHeaders.setLimit(n4);
                    continue;
                }
                bl4 = false;
            }
            while (!bl2) {
                if ((this.readChunk == null || this.readChunk.position() >= this.readChunk.limit()) && this.readBytes() < 0) {
                    this.throwEOFException(sm.getString("chunkedInputFilter.eosTrailer"));
                }
                if ((by = this.readChunk.get(this.readChunk.position())) == 13 || by == 10) {
                    this.parseCRLF(true);
                    bl2 = true;
                } else {
                    if (HttpParser.isControl(by) && by != 9) {
                        throw new IOException(sm.getString("chunkedInputFilter.invalidTrailerHeaderValue"));
                    }
                    if (this.trailingHeaders.getEnd() >= this.trailingHeaders.getLimit()) {
                        this.throwBadRequestException(sm.getString("chunkedInputFilter.maxTrailer"));
                    } else if (by == 32 || by == 9) {
                        this.trailingHeaders.append(by);
                    } else {
                        this.trailingHeaders.append(by);
                        n3 = this.trailingHeaders.getEnd();
                    }
                }
                if (bl2) continue;
                this.readChunk.position(this.readChunk.position() + 1);
            }
            if ((this.readChunk == null || this.readChunk.position() >= this.readChunk.limit()) && this.readBytes() < 0) {
                this.throwEOFException(sm.getString("chunkedInputFilter.eosTrailer"));
            }
            if ((by = this.readChunk.get(this.readChunk.position())) != 32 && by != 9) {
                bl3 = false;
                continue;
            }
            if (this.trailingHeaders.getEnd() >= this.trailingHeaders.getLimit()) {
                this.throwBadRequestException(sm.getString("chunkedInputFilter.maxTrailer"));
                continue;
            }
            bl2 = false;
            this.trailingHeaders.append(by);
        }
        String string = new String(this.trailingHeaders.getBytes(), n, n2 - n, StandardCharsets.ISO_8859_1);
        if (this.allowedTrailerHeaders.contains(string.toLowerCase(Locale.ENGLISH))) {
            MessageBytes messageBytes = mimeHeaders.addValue(string);
            messageBytes.setBytes(this.trailingHeaders.getBytes(), n2, n3 - n2);
        }
        return true;
    }

    private void throwBadRequestException(String string) throws IOException {
        this.error = true;
        throw new BadRequestException(string);
    }

    private void throwEOFException(String string) throws IOException {
        this.error = true;
        throw new EOFException(string);
    }

    private void checkError() throws IOException {
        if (this.error) {
            throw new IOException(sm.getString("chunkedInputFilter.error"));
        }
    }

    @Override
    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.readChunk = byteBuffer;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.readChunk;
    }

    @Override
    public void expand(int n) {
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(StandardCharsets.ISO_8859_1), 0, ENCODING_NAME.length());
    }
}

