/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import java.io.IOException;

public class GlsDefHook
extends ControlSequence {
    private String hookCsPrefix;
    private boolean allowEmptySuffix;

    public GlsDefHook(String string, String string2) {
        this(string, string2, true);
    }

    public GlsDefHook(String string, String string2, boolean bl) {
        super(string);
        this.hookCsPrefix = string2;
        this.allowEmptySuffix = bl;
    }

    @Override
    public Object clone() {
        return new GlsDefHook(this.getName(), this.hookCsPrefix, this.allowEmptySuffix);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2;
        String string = this.popLabelString(teXParser, teXObjectList);
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        if (!this.allowEmptySuffix && string.isEmpty()) {
            throw new LaTeXSyntaxException(teXParser, "glossaries.empty_category_not_allowed", this.toString(teXParser));
        }
        if (teXParser.isStack(teXObject)) {
            teXObjectList2 = (TeXObjectList)teXObject;
        } else {
            teXObjectList2 = teXParser.getListener().createStack();
            teXObjectList2.add(teXObject);
        }
        teXParser.putControlSequence(true, new GenericCommand(true, this.hookCsPrefix + string, null, teXObjectList2));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

