\name{DICOMOrientImageFilter}
\alias{DICOMOrientImageFilter}
\title{DICOMOrientImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Permute axes and flip images as needed to obtain an approximation to
the desired orientation.
DICOMOrientImageFilter}
\details{
The physical location of all pixels in the image remains the same, but
the meta-data and the ordering of the stored pixels may change.
DICOMOrientImageFilter depends on a set of constants that describe all possible labels.
Directions are labeled in terms of following pairs:
Left and Right (Subject's left and right)
Anterior and Posterior (Subject's front and back)
Inferior and Superior (Subject's bottom and top, i.e. feet and head)
 The initials of these directions are used in a 3 letter code in the
enumerated type OrientationEnum. The initials are given fastest moving
index first, second fastest second, third fastest third, where the
label's direction indicates increasing values.
An ITK image with an identity direction cosine matrix is in LPS (Left,
Posterior, Superior) orientation as defined by the DICOM standard.
 \deqn{ LPS = \begin{Bmatrix} from\ right\ to\ \textbf{L}eft \\ from\ anterior\ towards\ \textbf{P}osterior \\ from\ inferior\ towards\ \textbf{S}uperior \end{Bmatrix} }
The output orientation is specified with
SetDesiredCoordinateOrientation. The input coordinate orientation is
computed from the input image's direction cosine matrix.
See:
DICOMOrient for the procedural interface
itk::DICOMOrientImageFilter for the Doxygen on the original ITK class.
DICOMOrientImageFilter}
%C++ includes: sitkDICOMOrientImageFilter.h
\section{Methods}{
\describe{
\item{ DICOMOrientImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetDesiredCoordinateOrientation() const:}{
Set/Get the desired coordinate orientation for the output image
}
\item{std::vector< bool > GetFlipAxes() const:}{
    Get flip axes.
This value is computed during Update.    This is a measurement. Its value is updated in the Execute
methods, so the value will only be valid after an execution.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetPermuteOrder() const:}{
    Get axes permute order.
This value is computed during Update.    This is a measurement. Its value is updated in the Execute
methods, so the value will only be valid after an execution.
}
\item{Self SetDesiredCoordinateOrientation(std::string DesiredCoordinateOrientation):}{
Set/Get the desired coordinate orientation for the output image
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~DICOMOrientImageFilter():}{
Destructor
}
}
}
