/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.rules.tree.HintableFeature;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.PatternHint;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

record DisjunctIndex(List<PatternHint> ownHints, long unhintedMask, @Nullable Object2LongMap<HintableFeature> hintedMasks, int hintMask, @Nullable DisjunctIndex next) {
    private static final int LONG_BITS = 64;

    static DisjunctIndex build(List<PatternHint> hints) {
        DisjunctIndex next = hints.size() > 64 ? DisjunctIndex.build(hints.subList(64, hints.size())) : null;
        List<PatternHint> ownHints = hints.size() > 64 ? hints.subList(0, 64) : hints;
        long unhinted = 0L;
        long mask = 1L;
        int kindMask = 0;
        Object2LongOpenHashMap index = new Object2LongOpenHashMap();
        for (PatternHint hint : ownHints) {
            List featureLists = StreamEx.of(hint.disjuncts()).map(PatternHint.Disjunct::bestOwnFeatures).toList();
            if (featureLists.contains(List.of())) {
                unhinted |= mask;
            } else {
                for (List list : featureLists) {
                    for (HintableFeature feature : list) {
                        index.merge((Object)feature, mask, (l1, l2) -> l1 | l2);
                        kindMask |= feature.kind;
                    }
                }
            }
            mask <<= 1;
        }
        int hintedCount = hints.size() - Long.bitCount(unhinted);
        if (hintedCount == 0) {
            return new DisjunctIndex(ownHints, 0L, null, 0, next);
        }
        return new DisjunctIndex(ownHints, unhinted, (Object2LongMap<HintableFeature>)index, kindMask, next);
    }

    long maskToCheck(Node node) {
        assert (this.hintedMasks != null);
        long result = this.unhintedMask;
        for (HintableFeature feature : node.hintableFeatures()) {
            if ((this.hintMask & feature.kind) == 0) continue;
            result |= this.hintedMasks.getOrDefault((Object)feature, 0L);
        }
        return result;
    }
}

