/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.workspace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.coode.mdock.DynamicConfigPanel;
import org.protege.editor.core.ui.view.View;
import org.protege.editor.core.ui.view.ViewComponentPlugin;
import org.protege.editor.core.ui.view.ViewComponentPluginLoader;
import org.protege.editor.core.ui.workspace.TabbedWorkspace;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.core.ui.workspace.WorkspaceTab;
import org.protege.editor.core.ui.workspace.WorkspaceViewsTab;

public class WorkspaceViewManager {
    private Set<WorkspaceViewsTab> registeredTabs = new HashSet<WorkspaceViewsTab>();
    private Map<String, ViewComponentPlugin> pluginMap = new HashMap<String, ViewComponentPlugin>();

    public void registerViews(WorkspaceViewsTab tab) {
        ViewComponentPluginLoader loader = new ViewComponentPluginLoader(tab.getWorkspace());
        Set plugins = loader.getPlugins();
        for (ViewComponentPlugin plugin : plugins) {
            this.pluginMap.put(plugin.getId(), plugin);
        }
        this.registeredTabs.add(tab);
    }

    public void unregisterViews(WorkspaceViewsTab tab) {
    }

    public ViewComponentPlugin getViewComponentPlugin(String id) {
        return this.pluginMap.get(id);
    }

    public List<ViewComponentPlugin> getViewComponentPlugins() {
        ArrayList<ViewComponentPlugin> list = new ArrayList<ViewComponentPlugin>();
        list.addAll(this.pluginMap.values());
        return list;
    }

    public void bringViewToFront(String viewId) {
        WorkspaceTab tab;
        ViewComponentPlugin plugin = this.pluginMap.get(viewId);
        if (plugin == null) {
            return;
        }
        Workspace ws = plugin.getWorkspace();
        if (ws instanceof TabbedWorkspace && (tab = ((TabbedWorkspace)ws).getSelectedTab()) instanceof WorkspaceViewsTab) {
            ((WorkspaceViewsTab)tab).bringViewToFront(viewId);
        }
    }

    public View showView(String viewId) {
        ViewComponentPlugin plugin = this.pluginMap.get(viewId);
        if (plugin == null) {
            return null;
        }
        Workspace ws = plugin.getWorkspace();
        if (ws instanceof TabbedWorkspace) {
            WorkspaceTab tab = ((TabbedWorkspace)ws).getSelectedTab();
            View view = new View(plugin, plugin.getWorkspace());
            DynamicConfigPanel pan = new DynamicConfigPanel(tab);
            pan.setCurrentComponent(view, plugin.getLabel());
            pan.activate();
        }
        return null;
    }
}

