/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.individual;

import com.google.common.collect.Sets;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.protege.editor.core.ui.RefreshableComponent;
import org.protege.editor.core.ui.view.DisposableAction;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.hierarchy.IndividualsByTypeHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProviderListener;
import org.protege.editor.owl.model.selection.SelectionDriver;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.action.DeleteIndividualAction;
import org.protege.editor.owl.ui.renderer.AddEntityIcon;
import org.protege.editor.owl.ui.renderer.OWLClassIcon;
import org.protege.editor.owl.ui.renderer.OWLIndividualIcon;
import org.protege.editor.owl.ui.tree.CountingOWLObjectTreeCellRenderer;
import org.protege.editor.owl.ui.tree.OWLModelManagerTree;
import org.protege.editor.owl.ui.tree.OWLObjectTree;
import org.protege.editor.owl.ui.tree.OWLObjectTreeNode;
import org.protege.editor.owl.ui.tree.OWLTreeDragAndDropHandler;
import org.protege.editor.owl.ui.view.AbstractOWLSelectionViewComponent;
import org.protege.editor.owl.ui.view.ChangeListenerMediator;
import org.protege.editor.owl.ui.view.CreateNewTarget;
import org.protege.editor.owl.ui.view.Findable;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLEntitySetProvider;

public class OWLIndividualsByTypeViewComponent
extends AbstractOWLSelectionViewComponent
implements Findable<OWLNamedIndividual>,
CreateNewTarget,
RefreshableComponent,
SelectionDriver {
    private OWLObjectTree<OWLObject> tree;
    private ChangeListenerMediator changeListenerMediator;
    private TreeSelectionListener listener = e -> this.transmitSelection();
    private HierarchyProviderWrapper hierarchyProvider;

    @Override
    public void initialiseView() throws Exception {
        this.setLayout(new BorderLayout());
        this.hierarchyProvider = new HierarchyProviderWrapper();
        this.tree = new OWLModelManagerTree<OWLObject>(this.getOWLEditorKit(), this.hierarchyProvider);
        this.tree.setCellRenderer(new CountingOWLObjectTreeCellRenderer<OWLObject>(this.getOWLEditorKit(), this.tree));
        this.tree.expandRow(0);
        this.add(new JScrollPane(this.tree));
        this.changeListenerMediator = new ChangeListenerMediator();
        this.tree.addTreeSelectionListener(this.listener);
        this.tree.setDragAndDropHandler(new OWLTreeDragAndDropHandler<OWLObject>(){

            @Override
            public boolean canDrop(Object child, Object parent) {
                return child instanceof OWLNamedIndividual && parent instanceof OWLClass;
            }

            @Override
            public void move(OWLObject child, OWLObject fromParent, OWLObject toParent) {
                OWLIndividualsByTypeViewComponent.this.handleMove(child, fromParent, toParent);
            }

            @Override
            public void add(OWLObject child, OWLObject parent) {
                OWLIndividualsByTypeViewComponent.this.handleAdd(child, parent);
            }
        });
        this.setupActions();
    }

    private IndividualsByTypeHierarchyProvider getProvider() {
        return this.getOWLModelManager().getOWLHierarchyManager().getOWLIndividualsByTypeHierarchyProvider();
    }

    private void handleAdd(OWLObject child, OWLObject toParent) {
        if (child instanceof OWLNamedIndividual) {
            OWLNamedIndividual ind = (OWLNamedIndividual)child;
            ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
            if (toParent != null && toParent instanceof OWLClass) {
                OWLClass to = (OWLClass)toParent;
                OWLClassAssertionAxiom ax = this.getOWLModelManager().getOWLDataFactory().getOWLClassAssertionAxiom((OWLClassExpression)to, (OWLIndividual)ind);
                changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
            }
            this.getOWLModelManager().applyChanges(changes);
        }
    }

    private void handleMove(OWLObject child, OWLObject fromParent, OWLObject toParent) {
        if (child instanceof OWLNamedIndividual) {
            OWLClassAssertionAxiom ax;
            OWLNamedIndividual ind = (OWLNamedIndividual)child;
            ArrayList<Object> changes = new ArrayList<Object>();
            if (toParent != null && toParent instanceof OWLClass) {
                OWLClass to = (OWLClass)toParent;
                ax = this.getOWLModelManager().getOWLDataFactory().getOWLClassAssertionAxiom((OWLClassExpression)to, (OWLIndividual)ind);
                changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
            }
            if (fromParent != null && fromParent instanceof OWLClass) {
                OWLClass from = (OWLClass)fromParent;
                ax = this.getOWLModelManager().getOWLDataFactory().getOWLClassAssertionAxiom((OWLClassExpression)from, (OWLIndividual)ind);
                for (OWLOntology ont : this.getOWLModelManager().getActiveOntologies()) {
                    if (!ont.containsAxiom((OWLAxiom)ax)) continue;
                    changes.add(new RemoveAxiom(ont, (OWLAxiom)ax));
                }
            }
            this.getOWLModelManager().applyChanges(changes);
        }
    }

    protected void setupActions() {
        this.addAction(new DisposableAction("Add individual", new AddEntityIcon(new OWLIndividualIcon())){

            public void actionPerformed(ActionEvent e) {
                OWLIndividualsByTypeViewComponent.this.createNewObject();
            }

            public void dispose() {
            }
        }, "A", "A");
        this.addAction(new DeleteIndividualAction(this.getOWLEditorKit(), (OWLEntitySetProvider<OWLNamedIndividual>)((OWLEntitySetProvider)() -> this.getSelectedIndividuals())), "B", "A");
        this.addAction(new DisposableAction("Add empty class to list", new AddEntityIcon(new OWLClassIcon())){

            public void dispose() {
            }

            public void actionPerformed(ActionEvent e) {
                OWLIndividualsByTypeViewComponent.this.addEmptyClassToList();
            }
        }, "C", "A");
    }

    private void addEmptyClassToList() {
        UIHelper helper = new UIHelper(this.getOWLEditorKit());
        OWLClass cls = helper.pickOWLClass();
        if (cls != null) {
            this.hierarchyProvider.addTemporaryClass(cls);
        }
    }

    @Override
    public void disposeView() {
        this.tree.dispose();
    }

    @Override
    protected boolean isOWLClassView() {
        return true;
    }

    @Override
    protected boolean isOWLIndividualView() {
        return true;
    }

    @Override
    protected final OWLObject updateView() {
        OWLObject sel = null;
        OWLEntity entity = this.getOWLWorkspace().getOWLSelectionModel().getSelectedEntity();
        if (entity instanceof OWLClass || entity instanceof OWLNamedIndividual) {
            sel = this.updateView((OWLObject)entity);
            if (sel != null) {
                this.updateRegisteredActions();
            } else {
                this.disableRegisteredActions();
            }
        }
        return sel;
    }

    private Set<OWLNamedIndividual> getSelectedIndividuals() {
        List<OWLObject> sel = this.tree.getSelectedOWLObjects();
        HashSet<OWLNamedIndividual> selIndivs = new HashSet<OWLNamedIndividual>();
        for (OWLObject obj : sel) {
            if (!(obj instanceof OWLNamedIndividual)) continue;
            selIndivs.add((OWLNamedIndividual)obj);
        }
        return selIndivs;
    }

    private OWLObject updateView(OWLObject selectedEntity) {
        OWLObject selObj = this.tree.getSelectedOWLObject();
        if (selectedEntity != null && selObj != null && selectedEntity.equals((Object)selObj)) {
            return selectedEntity;
        }
        this.tree.setSelectedOWLObject(selectedEntity);
        return selectedEntity;
    }

    private void transmitSelection() {
        if (this.isSynchronizing()) {
            OWLObject obj = this.tree.getSelectedOWLObject();
            if (obj instanceof OWLEntity) {
                this.setGlobalSelection((OWLEntity)obj);
            } else {
                this.setGlobalSelection(null);
            }
        }
        this.changeListenerMediator.fireStateChanged(this);
    }

    @Override
    public List<OWLNamedIndividual> find(String match) {
        return new ArrayList<OWLNamedIndividual>(this.getOWLModelManager().getOWLEntityFinder().getMatchingOWLIndividuals(match));
    }

    @Override
    public void show(OWLNamedIndividual owlEntity) {
        this.tree.setSelectedOWLObject((OWLObject)owlEntity);
    }

    public boolean canDelete() {
        return !this.getSelectedIndividuals().isEmpty();
    }

    public void handleDelete() {
    }

    @Override
    public boolean canCreateNew() {
        return true;
    }

    @Override
    public void createNewObject() {
        OWLEntityCreationSet<OWLNamedIndividual> set = this.getOWLWorkspace().createOWLIndividual();
        if (set == null) {
            return;
        }
        ArrayList<Object> changes = new ArrayList<Object>();
        changes.addAll(set.getOntologyChanges());
        OWLClass targetType = null;
        for (TreePath selectionPath = this.tree.getSelectionPath(); selectionPath != null; selectionPath = selectionPath.getParentPath()) {
            OWLObjectTreeNode node;
            if (!(selectionPath.getLastPathComponent() instanceof OWLObjectTreeNode) || !((node = (OWLObjectTreeNode)selectionPath.getLastPathComponent()).getOWLObject() instanceof OWLClass)) continue;
            targetType = (OWLClass)node.getOWLObject();
            break;
        }
        if (targetType != null) {
            OWLOntology ont = this.getOWLModelManager().getActiveOntology();
            changes.add(new AddAxiom(ont, (OWLAxiom)this.getOWLDataFactory().getOWLClassAssertionAxiom((OWLClassExpression)targetType, (OWLIndividual)set.getOWLEntity())));
        }
        this.getOWLModelManager().applyChanges(changes);
        OWLNamedIndividual ind = set.getOWLEntity();
        if (ind != null) {
            this.tree.setSelectedOWLObject((OWLObject)ind, false);
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeListenerMediator.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeListenerMediator.removeChangeListener(listener);
    }

    @Override
    public Component asComponent() {
        return this;
    }

    @Override
    public Optional<OWLObject> getSelection() {
        return Optional.ofNullable(this.tree.getSelectedOWLObject());
    }

    private class HierarchyProviderWrapper
    implements OWLObjectHierarchyProvider<OWLObject> {
        private final Set<OWLObject> temporaryClasses = new HashSet<OWLObject>();
        private final List<OWLObjectHierarchyProviderListener<OWLObject>> listeners = new ArrayList<OWLObjectHierarchyProviderListener<OWLObject>>();

        private HierarchyProviderWrapper() {
        }

        public void addTemporaryClass(OWLClass cls) {
            this.temporaryClasses.add((OWLObject)cls);
            for (OWLObjectHierarchyProviderListener<OWLObject> listener : this.listeners) {
                listener.nodeChanged((OWLObject)cls);
            }
        }

        @Override
        public void setOntologies(Set<OWLOntology> ontologies) {
            OWLIndividualsByTypeViewComponent.this.getProvider().setOntologies(ontologies);
        }

        @Override
        public Set<OWLObject> getRoots() {
            Sets.SetView roots = Sets.union(OWLIndividualsByTypeViewComponent.this.getProvider().getRoots(), this.temporaryClasses);
            return roots;
        }

        @Override
        public Set<OWLObject> getChildren(OWLObject object) {
            return OWLIndividualsByTypeViewComponent.this.getProvider().getChildren(object);
        }

        @Override
        public Set<OWLObject> getDescendants(OWLObject object) {
            return OWLIndividualsByTypeViewComponent.this.getProvider().getDescendants(object);
        }

        @Override
        public Set<OWLObject> getParents(OWLObject object) {
            if (this.temporaryClasses.contains(object)) {
                return Collections.emptySet();
            }
            return OWLIndividualsByTypeViewComponent.this.getProvider().getParents(object);
        }

        @Override
        public Set<OWLObject> getAncestors(OWLObject object) {
            return OWLIndividualsByTypeViewComponent.this.getProvider().getAncestors(object);
        }

        @Override
        public Set<OWLObject> getEquivalents(OWLObject object) {
            return OWLIndividualsByTypeViewComponent.this.getProvider().getEquivalents(object);
        }

        @Override
        public Set<List<OWLObject>> getPathsToRoot(OWLObject object) {
            if (this.temporaryClasses.contains(object)) {
                return Collections.singleton(Collections.singletonList(object));
            }
            return OWLIndividualsByTypeViewComponent.this.getProvider().getPathsToRoot(object);
        }

        @Override
        public boolean containsReference(OWLObject object) {
            return this.temporaryClasses.contains(object) || OWLIndividualsByTypeViewComponent.this.getProvider().containsReference(object);
        }

        @Override
        public void addListener(OWLObjectHierarchyProviderListener<OWLObject> listener) {
            this.listeners.add(listener);
            OWLIndividualsByTypeViewComponent.this.getProvider().addListener(listener);
        }

        @Override
        public void removeListener(OWLObjectHierarchyProviderListener<OWLObject> listener) {
            this.listeners.remove(listener);
            OWLIndividualsByTypeViewComponent.this.getProvider().removeListener(listener);
        }

        @Override
        public void dispose() {
            this.listeners.clear();
            OWLIndividualsByTypeViewComponent.this.getProvider().dispose();
        }
    }
}

