/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Span {
    private int startIndex = -1;
    private int endIndex = -1;

    public Span(int startIndex, int endIndex) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public boolean intersectsWith(Span span) {
        return span.startIndex < this.endIndex && span.endIndex > this.startIndex + 1;
    }

    public String toString() {
        return "Span(" + this.startIndex + ", " + this.endIndex + ")";
    }

    public int getLength() {
        return this.endIndex - this.startIndex;
    }

    public boolean isEmpty() {
        return this.endIndex <= this.startIndex;
    }

    public Span crop(int from, int to) {
        int croppedFrom = from > this.startIndex ? from : this.startIndex;
        int croppedTo = to < this.endIndex ? to : this.endIndex;
        return new Span(croppedFrom, croppedTo);
    }

    public List<Span> split(List<Integer> positions) {
        ArrayList<Span> stack = new ArrayList<Span>();
        stack.add(0, this);
        for (int position : positions) {
            if (position <= this.startIndex || position >= this.endIndex) continue;
            Span currentSpan = (Span)stack.get(0);
            if (position < currentSpan.startIndex || position >= currentSpan.endIndex) break;
            stack.remove(0);
            stack.add(0, new Span(currentSpan.startIndex, position));
            stack.add(0, new Span(position, currentSpan.endIndex));
        }
        Collections.reverse(stack);
        return stack;
    }
}

