/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy.tabbed;

import com.google.common.base.Optional;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.protege.editor.owl.model.hierarchy.tabbed.Edge;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.slf4j.LoggerFactory;

public abstract class AbstractOWLObjectHierarchyCreator {
    private OWLDataFactory dataFactory;
    private OWLOntology ontology;
    private List<Edge> edges;

    public AbstractOWLObjectHierarchyCreator(OWLDataFactory dataFactory, OWLOntology ontology, List<Edge> edges) {
        this.dataFactory = dataFactory;
        this.ontology = ontology;
        this.edges = edges;
    }

    public OWLDataFactory getDataFactory() {
        return this.dataFactory;
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    protected List<OWLOntologyChange> hierarchyCreationStart() {
        return Collections.emptyList();
    }

    public List<OWLOntologyChange> createHierarchy() {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        changes.addAll(this.hierarchyCreationStart());
        for (Edge e : this.edges) {
            if (e.isRoot()) {
                changes.add(this.getChange(e.getChild(), this.dataFactory));
                continue;
            }
            changes.add(this.getChange(e.getChild(), e.getParent(), this.dataFactory));
        }
        changes.addAll(this.hierarchyCreationEnd());
        return changes;
    }

    protected List<OWLOntologyChange> hierarchyCreationEnd() {
        return Collections.emptyList();
    }

    protected IRI getIRI(String s) {
        try {
            Optional defaultDocURI = this.ontology.getOntologyID().getDefaultDocumentIRI();
            return IRI.create((URI)new URI(((IRI)defaultDocURI.get()).getScheme(), ((IRI)defaultDocURI.get()).toURI().getSchemeSpecificPart(), s));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(AbstractOWLObjectHierarchyCreator.class).error("An error occurred whilst creating an IRI: {}", (Throwable)e);
            return null;
        }
    }

    public abstract OWLOntologyChange getChange(String var1, OWLDataFactory var2);

    public abstract OWLOntologyChange getChange(String var1, String var2, OWLDataFactory var3);
}

