"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeLegend = exports.getLegendExtra = void 0;
var constants_1 = require("../../../scales/constants");
var geometry_1 = require("../../../utils/geometry");
var series_sort_1 = require("../../../utils/series_sort");
var get_api_scales_1 = require("../scales/get_api_scales");
var spec_1 = require("../state/utils/spec");
var tooltip_1 = require("../tooltip/tooltip");
var axis_utils_1 = require("../utils/axis_utils");
var default_series_sort_fn_1 = require("../utils/default_series_sort_fn");
var group_data_series_1 = require("../utils/group_data_series");
var series_1 = require("../utils/series");
var specs_1 = require("../utils/specs");
function getPostfix(spec) {
    if (specs_1.isAreaSeriesSpec(spec) || specs_1.isBarSeriesSpec(spec)) {
        var _a = spec.y0AccessorFormat, y0AccessorFormat = _a === void 0 ? tooltip_1.Y0_ACCESSOR_POSTFIX : _a, _b = spec.y1AccessorFormat, y1AccessorFormat = _b === void 0 ? tooltip_1.Y1_ACCESSOR_POSTFIX : _b;
        return {
            y0AccessorFormat: y0AccessorFormat,
            y1AccessorFormat: y1AccessorFormat,
        };
    }
    return {};
}
function getBandedLegendItemLabel(name, yAccessor, postfixes) {
    return yAccessor === geometry_1.BandedAccessorType.Y1
        ? "" + name + postfixes.y1AccessorFormat
        : "" + name + postfixes.y0AccessorFormat;
}
function getLegendExtra(showLegendExtra, xScaleType, formatter, key, lastValue) {
    var _a;
    if (showLegendExtra) {
        var rawValue = (_a = (lastValue && lastValue[key])) !== null && _a !== void 0 ? _a : null;
        var formattedValue = rawValue !== null ? formatter(rawValue) : null;
        return {
            raw: rawValue !== null ? rawValue : null,
            formatted: xScaleType === constants_1.ScaleType.Ordinal ? null : formattedValue,
            legendSizingLabel: formattedValue,
        };
    }
    return {
        raw: null,
        formatted: null,
        legendSizingLabel: null,
    };
}
exports.getLegendExtra = getLegendExtra;
function computeLegend(dataSeries, lastValues, seriesColors, specs, defaultColor, axesSpecs, showLegendExtra, serialIdentifierDataSeriesMap, deselectedDataSeries, sortSeriesBy) {
    if (deselectedDataSeries === void 0) { deselectedDataSeries = []; }
    var legendItems = [];
    dataSeries.forEach(function (series) {
        var _a, _b;
        var specId = series.specId, yAccessor = series.yAccessor;
        var banded = series_1.isDataSeriesBanded(series);
        var key = series_1.getSeriesKey(series, series.groupId);
        var spec = spec_1.getSpecsById(specs, specId);
        var dataSeriesKey = series_1.getSeriesKey({
            specId: series.specId,
            yAccessor: series.yAccessor,
            splitAccessors: series.splitAccessors,
        }, series.groupId);
        var color = seriesColors.get(dataSeriesKey) || defaultColor;
        var hasSingleSeries = dataSeries.length === 1;
        var name = series_1.getSeriesName(series, hasSingleSeries, false, spec);
        var isSeriesHidden = deselectedDataSeries ? series_1.getSeriesIndex(deselectedDataSeries, series) >= 0 : false;
        if (name === '' || !spec) {
            return;
        }
        var postFixes = getPostfix(spec);
        var labelY1 = banded ? getBandedLegendItemLabel(name, geometry_1.BandedAccessorType.Y1, postFixes) : name;
        var yAxis = spec_1.getAxesSpecForSpecId(axesSpecs, spec.groupId).yAxis;
        var formatter = (_b = (_a = spec.tickFormat) !== null && _a !== void 0 ? _a : yAxis === null || yAxis === void 0 ? void 0 : yAxis.tickFormat) !== null && _b !== void 0 ? _b : axis_utils_1.defaultTickFormatter;
        var hideInLegend = spec.hideInLegend;
        var lastValue = lastValues.get(key);
        var seriesIdentifier = series_1.getSeriesIdentifierFromDataSeries(series);
        var xScaleType = get_api_scales_1.getXScaleTypeFromSpec(spec.xScaleType);
        legendItems.push({
            color: color,
            label: labelY1,
            seriesIdentifiers: [seriesIdentifier],
            childId: geometry_1.BandedAccessorType.Y1,
            isSeriesHidden: isSeriesHidden,
            isItemHidden: hideInLegend,
            isToggleable: true,
            defaultExtra: getLegendExtra(showLegendExtra, xScaleType, formatter, 'y1', lastValue),
            path: [{ index: 0, value: seriesIdentifier.key }],
            keys: __spread([specId, spec.groupId, yAccessor], series.splitAccessors.values()),
        });
        if (banded) {
            var labelY0 = getBandedLegendItemLabel(name, geometry_1.BandedAccessorType.Y0, postFixes);
            legendItems.push({
                color: color,
                label: labelY0,
                seriesIdentifiers: [seriesIdentifier],
                childId: geometry_1.BandedAccessorType.Y0,
                isSeriesHidden: isSeriesHidden,
                isItemHidden: hideInLegend,
                isToggleable: true,
                defaultExtra: getLegendExtra(showLegendExtra, xScaleType, formatter, 'y0', lastValue),
                path: [{ index: 0, value: seriesIdentifier.key }],
                keys: __spread([specId, spec.groupId, yAccessor], series.splitAccessors.values()),
            });
        }
    });
    var legendSortFn = series_sort_1.getLegendCompareFn(sortSeriesBy, function (a, b) {
        var aDs = serialIdentifierDataSeriesMap[a.key];
        var bDs = serialIdentifierDataSeriesMap[b.key];
        return default_series_sort_fn_1.defaultXYLegendSeriesSort(aDs, bDs);
    });
    return group_data_series_1.groupBy(legendItems.sort(function (a, b) { return legendSortFn(a.seriesIdentifiers[0], b.seriesIdentifiers[0]); }), function (_a) {
        var keys = _a.keys, childId = _a.childId;
        return __spread(keys, [childId]).join('__');
    }, true).map(function (d) {
        return __assign(__assign({}, d[0]), { seriesIdentifiers: d.map(function (_a) {
                var _b = __read(_a.seriesIdentifiers, 1), s = _b[0];
                return s;
            }), path: d.map(function (_a) {
                var _b = __read(_a.path, 1), p = _b[0];
                return p;
            }) });
    });
}
exports.computeLegend = computeLegend;
//# sourceMappingURL=legend.js.map