/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.util;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.ThreadContextElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.replication.metadata.store.ReplicationMetadata;
import org.opensearch.replication.util.OpenSearchThreadContextElement;
import org.opensearch.replication.util.SecurityContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/opensearch/replication/util/OpenSearchClientThreadContextElement;", "Lkotlinx/coroutines/ThreadContextElement;", "", "threadContext", "Lorg/opensearch/common/util/concurrent/ThreadContext;", "replicationMetadata", "Lorg/opensearch/replication/metadata/store/ReplicationMetadata;", "action", "", "injectSecurityContext", "", "defaultContext", "(Lorg/opensearch/common/util/concurrent/ThreadContext;Lorg/opensearch/replication/metadata/store/ReplicationMetadata;Ljava/lang/String;ZZ)V", "init", "key", "Lkotlin/coroutines/CoroutineContext$Key;", "getKey", "()Lkotlin/coroutines/CoroutineContext$Key;", "storedContext", "Lorg/opensearch/common/util/concurrent/ThreadContext$StoredContext;", "restoreThreadContext", "context", "Lkotlin/coroutines/CoroutineContext;", "oldState", "(Lkotlin/coroutines/CoroutineContext;Lkotlin/Unit;)V", "updateThreadContext", "Key", "opensearch-cross-cluster-replication"})
public final class OpenSearchClientThreadContextElement
implements ThreadContextElement<Unit> {
    @NotNull
    public static final Key Key = new Key(null);
    @NotNull
    private final ThreadContext threadContext;
    @Nullable
    private final ReplicationMetadata replicationMetadata;
    @NotNull
    private final String action;
    private final boolean injectSecurityContext;
    private final boolean defaultContext;
    @NotNull
    private ThreadContext.StoredContext storedContext;
    private boolean init;

    public OpenSearchClientThreadContextElement(@NotNull ThreadContext threadContext, @Nullable ReplicationMetadata replicationMetadata, @NotNull String action, boolean injectSecurityContext, boolean defaultContext) {
        Intrinsics.checkNotNullParameter((Object)threadContext, (String)"threadContext");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.threadContext = threadContext;
        this.replicationMetadata = replicationMetadata;
        this.action = action;
        this.injectSecurityContext = injectSecurityContext;
        this.defaultContext = defaultContext;
        ThreadContext.StoredContext storedContext = this.threadContext.newStoredContext(true);
        Intrinsics.checkNotNullExpressionValue((Object)storedContext, (String)"newStoredContext(...)");
        this.storedContext = storedContext;
    }

    @NotNull
    public CoroutineContext.Key<?> getKey() {
        return Key;
    }

    public void restoreThreadContext(@NotNull CoroutineContext context, @NotNull Unit oldState) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        ThreadContext.StoredContext storedContext = this.threadContext.stashContext();
        Intrinsics.checkNotNullExpressionValue((Object)storedContext, (String)"stashContext(...)");
        this.storedContext = storedContext;
        this.init = true;
    }

    public void updateThreadContext(@NotNull CoroutineContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.storedContext.close();
        if (!this.init) {
            ThreadContext.StoredContext storedContext;
            if (this.injectSecurityContext || this.defaultContext) {
                ThreadContext.StoredContext storedContext2 = this.threadContext.stashContext();
                storedContext = storedContext2;
                Intrinsics.checkNotNullExpressionValue((Object)storedContext2, (String)"stashContext(...)");
            } else {
                ThreadContext.StoredContext storedContext3 = this.threadContext.newStoredContext(true);
                storedContext = storedContext3;
                Intrinsics.checkNotNullExpressionValue((Object)storedContext3, (String)"newStoredContext(...)");
            }
            this.storedContext = storedContext;
            if (this.injectSecurityContext) {
                SecurityContext.Companion.setBasedOnActions(this.replicationMetadata, this.action, this.threadContext);
            }
        }
    }

    public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        return (R)ThreadContextElement.DefaultImpls.fold((ThreadContextElement)this, initial, operation);
    }

    @Nullable
    public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key) {
        return (E)ThreadContextElement.DefaultImpls.get((ThreadContextElement)this, key);
    }

    @NotNull
    public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key) {
        return ThreadContextElement.DefaultImpls.minusKey((ThreadContextElement)this, key);
    }

    @NotNull
    public CoroutineContext plus(@NotNull CoroutineContext context) {
        return ThreadContextElement.DefaultImpls.plus((ThreadContextElement)this, (CoroutineContext)context);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/opensearch/replication/util/OpenSearchClientThreadContextElement$Key;", "Lkotlin/coroutines/CoroutineContext$Key;", "Lorg/opensearch/replication/util/OpenSearchThreadContextElement;", "()V", "opensearch-cross-cluster-replication"})
    public static final class Key
    implements CoroutineContext.Key<OpenSearchThreadContextElement> {
        private Key() {
        }

        public /* synthetic */ Key(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

