/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.sql.SQLException;

public interface OracleLargeObject<T> {
    public void freeTemporary() throws SQLException;

    public void freeLOB() throws SQLException;

    public boolean isTemporary() throws SQLException;

    public short getDuration() throws SQLException;

    public boolean isFree();

    public void setPrefetchData(PrefetchData<T> var1);

    public PrefetchData<T> getPrefetchData();

    public static final class ArrayPrefetchData<T>
    implements PrefetchData<T> {
        private final T array;
        private final int length;

        private ArrayPrefetchData(T array, int length) {
            this.array = array;
            this.length = length;
        }

        @Override
        public int copy(int srcOffset, T dst, int dstOffset, int length) {
            int copyLength = Math.min(length, this.length - srcOffset);
            if (copyLength < 1) {
                return 0;
            }
            System.arraycopy(this.array, srcOffset, dst, dstOffset, copyLength);
            return copyLength;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public T share() {
            return this.array;
        }
    }

    public static interface PrefetchData<T> {
        public static <T> PrefetchData<T> wrapArray(T array, int length) {
            if (!(1.$assertionsDisabled || array != null && array.getClass().isArray())) {
                throw new AssertionError((Object)("Not an array: " + array));
            }
            return new ArrayPrefetchData<T>(array, length);
        }

        public int copy(int var1, T var2, int var3, int var4);

        public int length();

        public T share();

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
        }
    }
}

