/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;

public class PropertyAccessStrategyBackRefImpl
implements PropertyAccessStrategy {
    public static final Serializable UNKNOWN = new Serializable(){

        public String toString() {
            return "<unknown>";
        }

        public Object readResolve() {
            return UNKNOWN;
        }
    };
    private final String entityName;
    private final String propertyName;

    public PropertyAccessStrategyBackRefImpl(String collectionRole, String entityName) {
        this.entityName = entityName;
        this.propertyName = collectionRole.substring(entityName.length() + 1);
    }

    @Override
    public PropertyAccess buildPropertyAccess(Class<?> containerJavaType, String propertyName, boolean setterRequired) {
        return new PropertyAccessBackRefImpl(this);
    }

    private static class PropertyAccessBackRefImpl
    implements PropertyAccess {
        private final PropertyAccessStrategyBackRefImpl strategy;
        private final GetterImpl getter;

        public PropertyAccessBackRefImpl(PropertyAccessStrategyBackRefImpl strategy) {
            this.strategy = strategy;
            this.getter = new GetterImpl(strategy.entityName, strategy.propertyName);
        }

        @Override
        public PropertyAccessStrategy getPropertyAccessStrategy() {
            return this.strategy;
        }

        @Override
        public Getter getGetter() {
            return this.getter;
        }

        @Override
        public Setter getSetter() {
            return SetterImpl.INSTANCE;
        }
    }

    private static class SetterImpl
    implements Setter {
        public static final Setter INSTANCE = new SetterImpl();

        private SetterImpl() {
        }

        @Override
        public void set(Object target, @Nullable Object value) {
        }

        @Override
        public @Nullable String getMethodName() {
            return null;
        }

        @Override
        public @Nullable Method getMethod() {
            return null;
        }
    }

    private static class GetterImpl
    implements Getter {
        private final String entityName;
        private final String propertyName;

        public GetterImpl(String entityName, String propertyName) {
            this.entityName = entityName;
            this.propertyName = propertyName;
        }

        @Override
        public Object get(Object owner) {
            return UNKNOWN;
        }

        @Override
        public Object getForInsert(Object owner, Map<Object, Object> mergeMap, SharedSessionContractImplementor session) {
            return session.getPersistenceContextInternal().getOwnerId(this.entityName, this.propertyName, owner, mergeMap);
        }

        @Override
        public Class<?> getReturnTypeClass() {
            return Object.class;
        }

        @Override
        public Type getReturnType() {
            return Object.class;
        }

        @Override
        public @Nullable Member getMember() {
            return null;
        }

        @Override
        public @Nullable String getMethodName() {
            return null;
        }

        @Override
        public @Nullable Method getMethod() {
            return null;
        }
    }
}

